/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileOutputStream;
import java.util.ArrayList;

public class RaidGroupDatabase
extends AbstractDatabase {
    private RaidGroupDescriptor[] raidGroupArray;
    final String[] raidGroupDefaultLabels = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};

    RaidGroupDatabase(DatabaseManager databaseManager) {
        super(databaseManager, "RaidGroup");
        this.raidGroupArray = new RaidGroupDescriptor[128];
    }

    public synchronized void initialize() {
        int raidGroup;
        super.initialize();
        for (raidGroup = 0; raidGroup < this.raidGroupArray.length; ++raidGroup) {
            this.raidGroupArray[raidGroup] = null;
        }
        this.raidGroupArray = new RaidGroupDescriptor[this.databaseManager.getSelectedController().maxRaidGroups];
        for (raidGroup = 0; raidGroup < this.raidGroupArray.length; ++raidGroup) {
            this.raidGroupArray[raidGroup] = new RaidGroupDescriptor(raidGroup);
        }
        this.getFirst();
    }

    public synchronized void nuke() {
        super.nuke();
    }

    public void snapshot(FileOutputStream outputStream) {
    }

    protected synchronized void processNewData(Message message) {
        try {
            XmlData xmlData = new XmlData(message.response);
            if (xmlData.getNextElement()) {
                if (xmlData.element.equals("Fault")) {
                    FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                    if (this.initializing && faultDescriptor.reason.equals("None Found")) {
                        this.initializationComplete();
                    }
                } else if (xmlData.element.equals("RaidGroupInfo")) {
                    RaidGroupDescriptor raidGroupDescriptor;
                    this.raidGroupArray[raidGroupDescriptor.raidGroup] = raidGroupDescriptor = new RaidGroupDescriptor(xmlData.elementValue);
                    if (this.initializing) {
                        this.getNext(raidGroupDescriptor.raidGroup);
                    } else {
                        this.notifyListeners();
                    }
                }
            }
        }
        catch (Exception exception) {
            ErrorLog.put(exception, "RAID Group Database Exception\nMessage " + message.response);
        }
    }

    protected void processUpdateCountsMessage(Message message) {
        String data = message.response;
        try {
            for (int raidGroup = 0; raidGroup < this.raidGroupArray.length; ++raidGroup) {
                this.raidGroupArray[raidGroup].receivedUpdateCount = false;
            }
            XmlData xmlData = new XmlData(data);
            while (xmlData.getNextElement()) {
                if (!xmlData.element.equals("RaidGroupUpdateCount")) continue;
                String raidGroup = null;
                String updateCount = null;
                XmlData updateXmlData = new XmlData(xmlData.elementValue);
                while (updateXmlData.getNextElement()) {
                    if (updateXmlData.element.equals("RaidGroup")) {
                        raidGroup = updateXmlData.elementValue;
                        continue;
                    }
                    if (!updateXmlData.element.equals("Count")) continue;
                    updateCount = updateXmlData.elementValue;
                }
                if (raidGroup == null || updateCount == null) continue;
                RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[Integer.parseInt(raidGroup)];
                raidGroupDescriptor.receivedUpdateCount = true;
                if (raidGroupDescriptor.updateCount.equals(updateCount)) continue;
                this.getThis(Integer.parseInt(raidGroup));
            }
            for (int raidGroup = 0; raidGroup < this.raidGroupArray.length; ++raidGroup) {
                if (this.raidGroupArray[raidGroup].receivedUpdateCount || this.raidGroupArray[raidGroup].status.equals("Unused")) continue;
                this.getThis(raidGroup);
            }
        }
        catch (Exception exception) {
            ErrorLog.put(exception, "RAID Group Database Process Update Counts Exception\n " + data);
        }
    }

    public RaidGroupDescriptor get(int raidGroup) {
        return (RaidGroupDescriptor)this.raidGroupArray[raidGroup].clone();
    }

    public synchronized ArrayList getRaidGroupList(boolean onlyRedundant) {
        ArrayList<Object> requestedRaidGroupList = new ArrayList<Object>();
        for (int raidGroup = 0; raidGroup < this.raidGroupArray.length; ++raidGroup) {
            RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup];
            if (raidGroupDescriptor.status.equals("Unused") || onlyRedundant && !raidGroupDescriptor.configuration.equals("Mirrored") && !raidGroupDescriptor.configuration.equals("Mirrored Striped") && !raidGroupDescriptor.configuration.equals("Parity RAID")) continue;
            requestedRaidGroupList.add(raidGroupDescriptor.clone());
        }
        return requestedRaidGroupList;
    }

    public synchronized ArrayList getRaidGroupList(String raidGroupStatus) {
        ArrayList<Object> requestedRaidGroupList = new ArrayList<Object>();
        for (int raidGroup = 0; raidGroup < this.raidGroupArray.length; ++raidGroup) {
            RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup];
            if (!raidGroupDescriptor.status.equals(raidGroupStatus)) continue;
            requestedRaidGroupList.add(raidGroupDescriptor.clone());
        }
        return requestedRaidGroupList;
    }

    public synchronized ArrayList getRaidGroupList(String[] statuses) {
        ArrayList<Object> requestedRaidGroupList = new ArrayList<Object>();
        block0: for (int raidGroup = 0; raidGroup < this.raidGroupArray.length; ++raidGroup) {
            RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup];
            for (int count = 0; count < statuses.length; ++count) {
                if (!statuses[count].equals(raidGroupDescriptor.status)) continue;
                requestedRaidGroupList.add(raidGroupDescriptor.clone());
                continue block0;
            }
        }
        return requestedRaidGroupList;
    }

    public synchronized ArrayList getRaidGroupList(boolean onlyRedundant, String metadataFormat) {
        ArrayList<Object> requestedRaidGroupList = new ArrayList<Object>();
        for (int raidGroup = 0; raidGroup < this.raidGroupArray.length; ++raidGroup) {
            RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup];
            if (raidGroupDescriptor.status.equals("Unused") || onlyRedundant && !raidGroupDescriptor.configuration.equals("Mirrored") && !raidGroupDescriptor.configuration.equals("Mirrored Striped") && !raidGroupDescriptor.configuration.equals("Parity RAID") || !raidGroupDescriptor.metadataFormat.equals(metadataFormat)) continue;
            requestedRaidGroupList.add(raidGroupDescriptor.clone());
        }
        return requestedRaidGroupList;
    }

    public synchronized ArrayList getRaidGroupList(String[] statuses, boolean onlyRedundant) {
        ArrayList<Object> requestedRaidGroupList = new ArrayList<Object>();
        for (int raidGroup = 0; raidGroup < this.raidGroupArray.length; ++raidGroup) {
            RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup];
            for (int count = 0; count < statuses.length; ++count) {
                if (!statuses[count].equals(raidGroupDescriptor.status) || onlyRedundant && !raidGroupDescriptor.configuration.equals("Mirrored") && !raidGroupDescriptor.configuration.equals("Mirrored Striped") && !raidGroupDescriptor.configuration.equals("Parity RAID")) continue;
                requestedRaidGroupList.add(raidGroupDescriptor.clone());
            }
        }
        return requestedRaidGroupList;
    }

    public synchronized ArrayList getRaidGroupList(String[] statuses, boolean onlyRedundant, String metadataFormat) {
        ArrayList<Object> requestedRaidGroupList = new ArrayList<Object>();
        for (int raidGroup = 0; raidGroup < this.raidGroupArray.length; ++raidGroup) {
            RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup];
            for (int count = 0; count < statuses.length; ++count) {
                if (!statuses[count].equals(raidGroupDescriptor.status) || onlyRedundant && !raidGroupDescriptor.configuration.equals("Mirrored") && !raidGroupDescriptor.configuration.equals("Mirrored Striped") && !raidGroupDescriptor.configuration.equals("Parity RAID") || !raidGroupDescriptor.metadataFormat.equals(metadataFormat)) continue;
                requestedRaidGroupList.add(raidGroupDescriptor.clone());
            }
        }
        return requestedRaidGroupList;
    }

    public synchronized ArrayList getValidationStateRaidGroupList(String metadataFormat, boolean onlyRedundant, String validationState) {
        ArrayList<Object> requestedRaidGroupList = new ArrayList<Object>();
        for (int raidGroup = 0; raidGroup < this.raidGroupArray.length; ++raidGroup) {
            RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup];
            if (!raidGroupDescriptor.metadataFormat.equals(metadataFormat) || !raidGroupDescriptor.status.equals("Offline") || onlyRedundant && !raidGroupDescriptor.configuration.equals("Mirrored") && !raidGroupDescriptor.configuration.equals("Mirrored Striped") && !raidGroupDescriptor.configuration.equals("Parity RAID") || !raidGroupDescriptor.validateState.equals(validationState)) continue;
            requestedRaidGroupList.add(raidGroupDescriptor.clone());
        }
        return requestedRaidGroupList;
    }

    public synchronized ArrayList getMinimumRaidGroupList(String metadataFormat) {
        return this.getValidationStateRaidGroupList(metadataFormat, true, "Minimum");
    }

    public synchronized ArrayList getIncompleteRaidGroupList(String metadataFormat, boolean onlyRedundant) {
        return this.getValidationStateRaidGroupList(metadataFormat, onlyRedundant, "Incomplete");
    }

    public synchronized boolean minimumRaidGroupExists(String metadataFormat) {
        ArrayList raidGroupList = this.getMinimumRaidGroupList(metadataFormat);
        return raidGroupList.size() > 0;
    }

    public synchronized boolean incompleteRaidGroupExists(String metadataFormat, boolean onlyRedundant) {
        ArrayList raidGroupList = this.getIncompleteRaidGroupList(metadataFormat, onlyRedundant);
        return raidGroupList.size() > 0;
    }

    public synchronized int getRaidGroupCount(String[] configurations) {
        ArrayList<Object> requestedRaidGroupList = new ArrayList<Object>();
        block0: for (int raidGroup = 0; raidGroup < this.raidGroupArray.length; ++raidGroup) {
            RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup];
            for (int count = 0; count < configurations.length; ++count) {
                if (raidGroupDescriptor.status.equals("Unused") || !configurations[count].equals(raidGroupDescriptor.configuration)) continue;
                requestedRaidGroupList.add(raidGroupDescriptor.clone());
                continue block0;
            }
        }
        return requestedRaidGroupList.size();
    }

    public synchronized int getSingleMemRaidGroupCount() {
        int raidGroupCount = 0;
        for (int raidGroup = 0; raidGroup < this.raidGroupArray.length; ++raidGroup) {
            RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup];
            if (!raidGroupDescriptor.status.equals("Online") && !raidGroupDescriptor.status.equals("Reduced") && !raidGroupDescriptor.status.equals("Offline") || raidGroupDescriptor.memberArray.size() != 1) continue;
            ++raidGroupCount;
        }
        return raidGroupCount;
    }

    public synchronized int getMultiMemRaidGroupCount() {
        int raidGroupCount = 0;
        for (int raidGroup = 0; raidGroup < this.raidGroupArray.length; ++raidGroup) {
            RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup];
            if (!raidGroupDescriptor.status.equals("Online") && !raidGroupDescriptor.status.equals("Reduced") && !raidGroupDescriptor.status.equals("Offline") || raidGroupDescriptor.memberArray.size() <= 1) continue;
            ++raidGroupCount;
        }
        return raidGroupCount;
    }

    public synchronized int getNextAvailableRaidGroup() {
        for (int raidGroup = 0; raidGroup < this.raidGroupArray.length; ++raidGroup) {
            RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup];
            if (!raidGroupDescriptor.status.equals("Unused")) continue;
            return raidGroup;
        }
        return -1;
    }

    public synchronized String[] getAvailableRaidGroupNumbers() {
        RaidGroupDescriptor raidGroupDescriptor;
        int raidGroup;
        int availableRaidGroupCount = 0;
        int maxRaidGroupCount = this.databaseManager.maximumRaidGroups;
        for (raidGroup = 0; raidGroup < this.raidGroupArray.length; ++raidGroup) {
            raidGroupDescriptor = this.raidGroupArray[raidGroup];
            if (!raidGroupDescriptor.status.equals("Online") && !raidGroupDescriptor.status.equals("Reduced") && !raidGroupDescriptor.status.equals("Offline")) continue;
            if (--maxRaidGroupCount < 0) {
                maxRaidGroupCount = 0;
            }
            if (maxRaidGroupCount == 0) break;
        }
        for (raidGroup = 0; raidGroup < this.raidGroupArray.length; ++raidGroup) {
            raidGroupDescriptor = this.raidGroupArray[raidGroup];
            if (!raidGroupDescriptor.status.equals("Unused")) continue;
            ++availableRaidGroupCount;
        }
        if (availableRaidGroupCount < maxRaidGroupCount) {
            maxRaidGroupCount = availableRaidGroupCount;
        }
        String[] availableRaidGroupNumbers = new String[maxRaidGroupCount];
        availableRaidGroupCount = 0;
        if (availableRaidGroupNumbers.length > 0) {
            for (raidGroup = 0; raidGroup < this.raidGroupArray.length; ++raidGroup) {
                raidGroupDescriptor = this.raidGroupArray[raidGroup];
                if (!raidGroupDescriptor.status.equals("Unused")) continue;
                availableRaidGroupNumbers[availableRaidGroupCount++] = Integer.toString(raidGroup);
                if (availableRaidGroupCount >= maxRaidGroupCount) break;
            }
        }
        return availableRaidGroupNumbers;
    }

    public synchronized String[] getUsedRaidGroupNumbers(String[] metadataFormats, boolean onlyRedundant) {
        int formatCount;
        RaidGroupDescriptor raidGroupDescriptor;
        int raidGroup;
        int usedRaidGroupCount = 0;
        for (raidGroup = 0; raidGroup < this.raidGroupArray.length; ++raidGroup) {
            raidGroupDescriptor = this.raidGroupArray[raidGroup];
            for (formatCount = 0; formatCount < metadataFormats.length; ++formatCount) {
                if (!metadataFormats[formatCount].equals(raidGroupDescriptor.metadataFormat) && !metadataFormats[formatCount].equals("All") || !raidGroupDescriptor.status.equals("Online") && !raidGroupDescriptor.status.equals("Reduced") && !raidGroupDescriptor.status.equals("Offline") || onlyRedundant && !raidGroupDescriptor.configuration.equals("Mirrored") && !raidGroupDescriptor.configuration.equals("Mirrored Striped") && !raidGroupDescriptor.configuration.equals("Parity RAID")) continue;
                ++usedRaidGroupCount;
            }
        }
        String[] usedRaidGroupNumbers = new String[usedRaidGroupCount];
        usedRaidGroupCount = 0;
        for (raidGroup = 0; raidGroup < this.raidGroupArray.length; ++raidGroup) {
            raidGroupDescriptor = this.raidGroupArray[raidGroup];
            for (formatCount = 0; formatCount < metadataFormats.length; ++formatCount) {
                if (!metadataFormats[formatCount].equals(raidGroupDescriptor.metadataFormat) && !metadataFormats[formatCount].equals("All") || !raidGroupDescriptor.status.equals("Online") && !raidGroupDescriptor.status.equals("Reduced") && !raidGroupDescriptor.status.equals("Offline") || onlyRedundant && !raidGroupDescriptor.configuration.equals("Mirrored") && !raidGroupDescriptor.configuration.equals("Mirrored Striped") && !raidGroupDescriptor.configuration.equals("Parity RAID")) continue;
                usedRaidGroupNumbers[usedRaidGroupCount++] = Integer.toString(raidGroup);
            }
        }
        return usedRaidGroupNumbers;
    }

    public synchronized int getMaxLegacyRaidGroups() {
        int maxLegacyGroupCount = Utility.minInt(4, this.databaseManager.controllerDatabase.getMaxPhysicalPathCount());
        int maxRaidGroupCount = this.databaseManager.maximumRaidGroups;
        return Utility.minInt(maxLegacyGroupCount, maxRaidGroupCount);
    }

    public synchronized String[] getAvailableLegacyRaidGroupNumbers() {
        RaidGroupDescriptor raidGroupDescriptor;
        int raidGroup;
        int availableRaidGroupCount = 0;
        int maxLegacyRaidGroupCount = this.getMaxLegacyRaidGroups();
        for (raidGroup = 0; raidGroup < this.raidGroupArray.length; ++raidGroup) {
            raidGroupDescriptor = this.raidGroupArray[raidGroup];
            if (!raidGroupDescriptor.status.equals("Online") && !raidGroupDescriptor.status.equals("Reduced") && !raidGroupDescriptor.status.equals("Offline") || !raidGroupDescriptor.metadataFormat.equals("Old")) continue;
            if (--maxLegacyRaidGroupCount < 0) {
                maxLegacyRaidGroupCount = 0;
            }
            if (maxLegacyRaidGroupCount == 0) break;
        }
        for (raidGroup = 0; raidGroup < this.raidGroupArray.length; ++raidGroup) {
            raidGroupDescriptor = this.raidGroupArray[raidGroup];
            if (!raidGroupDescriptor.status.equals("Unused")) continue;
            ++availableRaidGroupCount;
        }
        if (availableRaidGroupCount < maxLegacyRaidGroupCount) {
            maxLegacyRaidGroupCount = availableRaidGroupCount;
        }
        String[] availableRaidGroupNumbers = new String[maxLegacyRaidGroupCount];
        availableRaidGroupCount = 0;
        if (availableRaidGroupNumbers.length > 0) {
            for (raidGroup = 0; raidGroup < this.raidGroupArray.length; ++raidGroup) {
                raidGroupDescriptor = this.raidGroupArray[raidGroup];
                if (!raidGroupDescriptor.status.equals("Unused")) continue;
                availableRaidGroupNumbers[availableRaidGroupCount++] = Integer.toString(raidGroup);
                if (availableRaidGroupCount >= maxLegacyRaidGroupCount) break;
            }
        }
        return availableRaidGroupNumbers;
    }

    public synchronized int getLegacyRaidGroupCount() {
        int legacyRaidGroupCount = 0;
        for (int raidGroup = 0; raidGroup < this.raidGroupArray.length; ++raidGroup) {
            RaidGroupDescriptor raidGroupDescriptor = this.raidGroupArray[raidGroup];
            if (!raidGroupDescriptor.status.equals("Online") && !raidGroupDescriptor.status.equals("Reduced") && !raidGroupDescriptor.status.equals("Offline") || !raidGroupDescriptor.metadataFormat.equals("Old")) continue;
            ++legacyRaidGroupCount;
        }
        return legacyRaidGroupCount;
    }

    public boolean legacyRaidGroupMaxReached() {
        int maxLegacyRaidGroupCount;
        int legacyRaidGroupCount = this.getLegacyRaidGroupCount();
        return legacyRaidGroupCount >= (maxLegacyRaidGroupCount = this.getMaxLegacyRaidGroups());
    }

    public synchronized boolean legacyRaidGroupExists() {
        ArrayList raidGroupList = this.getRaidGroupList(false);
        for (int raidGroupIndex = 0; raidGroupIndex < raidGroupList.size(); ++raidGroupIndex) {
            RaidGroupDescriptor raidGroup = (RaidGroupDescriptor)raidGroupList.get(raidGroupIndex);
            if (!raidGroup.metadataFormat.equals("Old")) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean legacyReducedRaidGroupExists() {
        ArrayList raidGroupList = this.getRaidGroupList(false);
        for (int raidGroupIndex = 0; raidGroupIndex < raidGroupList.size(); ++raidGroupIndex) {
            RaidGroupDescriptor raidGroup = (RaidGroupDescriptor)raidGroupList.get(raidGroupIndex);
            if (!raidGroup.metadataFormat.equals("Old") || !raidGroup.status.equals("Reduced")) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean newRaidGroupExists() {
        ArrayList raidGroupList = this.getRaidGroupList(false);
        for (int raidGroupIndex = 0; raidGroupIndex < raidGroupList.size(); ++raidGroupIndex) {
            RaidGroupDescriptor raidGroup = (RaidGroupDescriptor)raidGroupList.get(raidGroupIndex);
            if (!raidGroup.metadataFormat.equals("New")) continue;
            return true;
        }
        return false;
    }

    public synchronized boolean newReducedRaidGroupExists() {
        ArrayList raidGroupList = this.getRaidGroupList(false);
        for (int raidGroupIndex = 0; raidGroupIndex < raidGroupList.size(); ++raidGroupIndex) {
            RaidGroupDescriptor raidGroup = (RaidGroupDescriptor)raidGroupList.get(raidGroupIndex);
            if (!raidGroup.metadataFormat.equals("New") || !raidGroup.status.equals("Reduced") || !this.databaseManager.deviceDatabase.rebuildSegmentExists(raidGroup.raidGroup)) continue;
            return true;
        }
        return false;
    }

    public boolean raidGroupLabelExists(String[] raidGroupStatuses, String raidGroupLabel) {
        ArrayList raidGroupList = this.getRaidGroupList(raidGroupStatuses, false, "New");
        for (int raidGroup = 0; raidGroup < raidGroupList.size(); ++raidGroup) {
            RaidGroupDescriptor raidGroupDescriptor = (RaidGroupDescriptor)raidGroupList.get(raidGroup);
            if (!raidGroupDescriptor.label.equals(raidGroupLabel)) continue;
            return true;
        }
        return false;
    }

    public String generateRaidGroupLabel(String[] raidGroupStatuses, String[] raidGroupNumbers) {
        return this.generateRaidGroupLabel(raidGroupStatuses, Integer.parseInt(raidGroupNumbers[0]));
    }

    public String generateRaidGroupLabel(String[] raidGroupStatuses, int raidGroupNumber) {
        String raidGroupLabel = "Volume " + this.raidGroupDefaultLabels[raidGroupNumber];
        if (this.raidGroupLabelExists(raidGroupStatuses, raidGroupLabel)) {
            raidGroupNumber = 0;
            raidGroupLabel = "Volume " + this.raidGroupDefaultLabels[raidGroupNumber];
            while (this.raidGroupLabelExists(raidGroupStatuses, raidGroupLabel)) {
                if (++raidGroupNumber >= this.raidGroupDefaultLabels.length) {
                    raidGroupLabel = "";
                    break;
                }
                raidGroupLabel = "Volume " + this.raidGroupDefaultLabels[raidGroupNumber];
            }
        }
        return raidGroupLabel;
    }

    public long getRaidGroupMemberCapacity(int raidGroupIndex) {
        long capacityPerMember;
        RaidGroupDescriptor raidGroup = this.get(raidGroupIndex);
        int chunkSizeInt = raidGroup.chunkSizeInt;
        int stripeWidth = Integer.parseInt(raidGroup.memberCount);
        if (raidGroup.configuration.equals("Parity RAID")) {
            --stripeWidth;
        } else if (raidGroup.configuration.equals("Mirrored")) {
            stripeWidth = 1;
        } else if (raidGroup.configuration.equals("Mirrored Striped")) {
            stripeWidth >>= 1;
        } else if (!raidGroup.configuration.equals("Striped")) {
            if (raidGroup.configuration.equals("Contiguous")) {
                stripeWidth = 1;
            } else if (raidGroup.configuration.equals("Concatenated")) {
                // empty if block
            }
        }
        if (stripeWidth == 0) {
            ++stripeWidth;
        }
        if (((capacityPerMember = raidGroup.capacityInBlocks / (long)stripeWidth) & (long)(chunkSizeInt - 1)) != 0L) {
            capacityPerMember = capacityPerMember + (long)chunkSizeInt & (long)(~(chunkSizeInt - 1));
        }
        return capacityPerMember;
    }
}

