/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class BringRaidGroupOnlineBox
extends KDialog {
    String metadataFormat;
    private RaidGroupTable raidGroupTable;
    private int selectedRaidGroup;
    private BringOnlineSingleThread bringOnlineSingleThread;
    private BringOnlineMultipleThread bringOnlineMultipleThread;

    public BringRaidGroupOnlineBox(DatabaseManager databaseManager, String title, String metadataFormat) {
        this.metadataFormat = metadataFormat;
        this.beginDialogInit(databaseManager, title, true);
        this.getContentPane().add((Component)this.buildRaidGroupTablePanel(), "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.completeDialogInit(true);
    }

    public BringRaidGroupOnlineBox(DatabaseManager databaseManager, int selectedRaidGroup, String metadataFormat) {
        this.databaseManager = databaseManager;
        this.metadataFormat = metadataFormat;
        this.selectedRaidGroup = selectedRaidGroup;
        this.storageManagementUtility = databaseManager.storageManagementUtility;
        this.commManager = databaseManager.commManager;
        this.bringOnlineSingleThread = new BringOnlineSingleThread();
        this.bringOnlineSingleThread.start();
    }

    protected JPanel buildRaidGroupTablePanel() {
        JPanel tablePanel = new JPanel();
        tablePanel.setLayout(new BoxLayout(tablePanel, 1));
        this.raidGroupTable = new RaidGroupTable(this.databaseManager, this.preferences, 12, "Minimum", this.metadataFormat);
        tablePanel.add(new JLabel("Select RAID Group(s):"));
        tablePanel.add(Box.createRigidArea(new Dimension(0, 3)));
        tablePanel.add(this.raidGroupTable.getScrollPane());
        tablePanel.setBorder(BorderFactory.createEmptyBorder(10, 14, 0, 14));
        return tablePanel;
    }

    private JPanel buildButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        JButton onlineButton = new JButton("Bring Online");
        JButton cancelButton = new JButton("Cancel");
        onlineButton.setMnemonic(68);
        cancelButton.setMnemonic(67);
        onlineButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BringRaidGroupOnlineBox.this.sendRequest();
                BringRaidGroupOnlineBox.this.closeDialog();
            }
        });
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BringRaidGroupOnlineBox.this.closeDialog();
            }
        });
        buttonPanel.add(onlineButton);
        buttonPanel.add(cancelButton);
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(4, 8, 4, 8));
        return buttonPanel;
    }

    protected void closeDialog() {
        this.raidGroupTable.dispose();
        this.dispose();
    }

    private void sendRequest() {
        this.bringOnlineMultipleThread = new BringOnlineMultipleThread();
        this.bringOnlineMultipleThread.start();
    }

    public void sendRequest(int raidGroup) {
        int answer;
        RaidGroupDescriptor raidGroupDescriptor = this.databaseManager.raidGroupDatabase.get(raidGroup);
        if (raidGroupDescriptor.writeCheckPointing.equals("Yes") && raidGroupDescriptor.returnDirtyData.equals("No") && (answer = JOptionPane.showConfirmDialog(this, "Based on the characteristics specified during the creation of this RAID Group,\n                     the RAID Group could be offlined.\n       Do you want to continue bringing the specified RAID Group online?", "Bring RAID Group Online Verification", 0)) == 1) {
            return;
        }
        String request = "<si:Request><si:Type>BringRaidGroupOnline</si:Type><si:RaidGroupParams><si:RaidGroup>" + raidGroup + "</si:RaidGroup>" + "</si:RaidGroupParams>" + "</si:Request>";
        Utility.println(request);
        AbstractMessageHandler responseMessageHandler = new AbstractMessageHandler(){

            public void handleMessage(Message message) {
                XmlData xmlData = new XmlData(message.response);
                if (xmlData.getNextElement() && xmlData.element.equals("Fault")) {
                    FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                    new ErrorMessageBox(BringRaidGroupOnlineBox.this, "The Requested Operation Failed: " + faultDescriptor.reason, "Bring RAID Group Online Error");
                }
                BringRaidGroupOnlineBox.this.databaseManager.refresh();
            }
        };
        this.commManager.sendMessage("Execute", request, responseMessageHandler);
    }

    private class BringOnlineMultipleThread
    extends Thread {
        private BringOnlineMultipleThread() {
        }

        public void run() {
            BringRaidGroupOnlineBox.this.storageManagementUtility.setWait();
            BringRaidGroupOnlineBox.this.setCursor(new Cursor(3));
            ArrayList raidGroupList = BringRaidGroupOnlineBox.this.raidGroupTable.getSelectedRaidGroups();
            for (int count = 0; count < raidGroupList.size(); ++count) {
                RaidGroupDescriptor raidGroupDescriptor = (RaidGroupDescriptor)raidGroupList.get(count);
                BringRaidGroupOnlineBox.this.sendRequest(raidGroupDescriptor.raidGroup);
            }
            BringRaidGroupOnlineBox.this.setCursor(new Cursor(0));
            BringRaidGroupOnlineBox.this.storageManagementUtility.clearWait();
        }
    }

    private class BringOnlineSingleThread
    extends Thread {
        private BringOnlineSingleThread() {
        }

        public void run() {
            BringRaidGroupOnlineBox.this.storageManagementUtility.setWait();
            BringRaidGroupOnlineBox.this.setCursor(new Cursor(3));
            BringRaidGroupOnlineBox.this.sendRequest(BringRaidGroupOnlineBox.this.selectedRaidGroup);
            BringRaidGroupOnlineBox.this.setCursor(new Cursor(0));
            BringRaidGroupOnlineBox.this.storageManagementUtility.clearWait();
        }
    }
}

