/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JDialog;

public abstract class KDialog
extends JDialog
implements GlobalConstants {
    protected StorageManagementUtility storageManagementUtility;
    protected DatabaseManager databaseManager;
    protected CommManager commManager;
    protected Preferences systemPreferences;
    protected Preferences preferences;
    protected final String FRAME_WIDTH = "Frame Width";
    protected final String FRAME_HEIGHT = "Frame Height";
    protected final String FRAME_X = "Frame X";
    protected final String FRAME_Y = "Frame Y";
    protected final String FRAME_OPEN = "Frame Open";
    protected boolean returnStatus;
    protected long returnValue;
    protected ArrayList returnList;

    protected void beginDialogInit(DatabaseManager databaseManager, String title, boolean modal) {
        this.databaseManager = databaseManager;
        this.storageManagementUtility = databaseManager.storageManagementUtility;
        this.commManager = databaseManager.commManager;
        this.setTitle(title);
        this.setModal(modal);
        if (modal) {
            this.storageManagementUtility.addModalWindow(this);
        }
        this.systemPreferences = Preferences.userRoot().node("/Sam/System");
        this.preferences = Preferences.userRoot().node("/Sam/" + title.replace('/', '-'));
    }

    protected void completeDialogInit(boolean autoCenter) {
        this.pack();
        Rectangle rectangle = Utility.getCenteredBounds(this);
        if (!autoCenter && this.systemPreferences.getBoolean("RememberLocations", true)) {
            rectangle.width = this.preferences.getInt("Frame Width", rectangle.width);
            rectangle.height = this.preferences.getInt("Frame Height", rectangle.height);
            rectangle.x = this.preferences.getInt("Frame X", rectangle.x);
            rectangle.y = this.preferences.getInt("Frame Y", rectangle.y);
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                KDialog.this.closeDialog();
            }
        });
        ((Component)this).setBounds(rectangle);
        this.setResizable(false);
        ((Component)this).setVisible(true);
    }

    protected void saveFrameBounds() {
        Rectangle rectangle = this.getBounds();
        this.preferences.putInt("Frame Width", rectangle.width);
        this.preferences.putInt("Frame Height", rectangle.height);
        this.preferences.putInt("Frame X", rectangle.x);
        this.preferences.putInt("Frame Y", rectangle.y);
    }

    protected void setReturnValue(long value) {
        this.returnValue = value;
    }

    protected void setReturnStatus(boolean status) {
        this.returnStatus = status;
    }

    protected void setReturnList(ArrayList list) {
        this.returnList = new ArrayList();
        for (int index = 0; index < list.size(); ++index) {
            this.returnList.add((String)list.get(index));
        }
    }

    public void dispose() {
        super.dispose();
        if (this.storageManagementUtility.isManagedModalWindow(this)) {
            this.storageManagementUtility.removeModalWindow(this);
        }
    }

    protected abstract void closeDialog();
}

