/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.UIManager;

public class SortBox
extends JDialog {
    JComboBox[] sortBox = new JComboBox[3];
    JRadioButton[] ascendingButton;
    JRadioButton[] descendingButton;
    SortInterface parent;
    int sortItems;

    public SortBox(SortInterface parent, String[] fieldNames, SortDescriptor[] sortDescriptors) {
        super((JFrame)((Object)parent), "Sort", true);
        this.sortItems = sortDescriptors.length;
        this.ascendingButton = new JRadioButton[3];
        this.descendingButton = new JRadioButton[3];
        this.parent = parent;
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.buildSortPanel(0, fieldNames, sortDescriptors[0], "Sort items by"));
        for (int field = 1; field < this.sortItems; ++field) {
            mainPanel.add(Box.createRigidArea(new Dimension(0, 4)));
            mainPanel.add(this.buildSortPanel(field, fieldNames, sortDescriptors[field], "Then by"));
        }
        mainPanel.setBorder(BorderFactory.createEmptyBorder(6, 12, 0, 12));
        this.getContentPane().add((Component)mainPanel, "Center");
        this.getContentPane().add((Component)this.buildButtonPanel(), "South");
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                SortBox.this.dispose();
            }
        });
        this.pack();
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        int w = this.getSize().width;
        int h = this.getSize().height;
        int x = (dim.width - w) / 2;
        int y = (dim.height - h) / 2;
        this.setBounds(x, y, w, h);
        this.setResizable(false);
        ((Component)this).setVisible(true);
    }

    private JPanel buildSortPanel(int index, String[] fieldNames, SortDescriptor sortDescriptor, String title) {
        this.sortBox[index] = new JComboBox<String>(fieldNames);
        Dimension boxDimension = this.sortBox[index].getPreferredSize();
        boxDimension.width = (int)((double)boxDimension.width * 1.4);
        this.sortBox[index].setPreferredSize(boxDimension);
        this.sortBox[index].setSelectedIndex(sortDescriptor.field);
        JPanel listPanel = new JPanel();
        listPanel.setLayout(new BoxLayout(listPanel, 1));
        listPanel.add(this.sortBox[index]);
        listPanel.add(Box.createRigidArea(new Dimension(0, 8)));
        this.ascendingButton[index] = new JRadioButton("Ascending");
        this.descendingButton[index] = new JRadioButton("Descending");
        if (sortDescriptor.direction == 1) {
            this.ascendingButton[index].setSelected(true);
            this.descendingButton[index].setSelected(false);
        } else {
            this.ascendingButton[index].setSelected(false);
            this.descendingButton[index].setSelected(true);
        }
        ButtonGroup group = new ButtonGroup();
        group.add(this.ascendingButton[index]);
        group.add(this.descendingButton[index]);
        Dimension ButtonDimension = this.ascendingButton[index].getPreferredSize();
        ButtonDimension.height = (int)((double)ButtonDimension.height * 0.7);
        this.ascendingButton[index].setPreferredSize(ButtonDimension);
        ButtonDimension = this.descendingButton[index].getPreferredSize();
        ButtonDimension.height = (int)((double)ButtonDimension.height * 1.3);
        this.descendingButton[index].setPreferredSize(ButtonDimension);
        JPanel checkPanel = new JPanel();
        checkPanel.setLayout(new BoxLayout(checkPanel, 1));
        checkPanel.add(this.ascendingButton[index]);
        checkPanel.add(this.descendingButton[index]);
        JPanel sortPanel = new JPanel();
        sortPanel.setLayout(new BoxLayout(sortPanel, 0));
        sortPanel.add(Box.createRigidArea(new Dimension(14, 0)));
        sortPanel.add(listPanel);
        sortPanel.add(Box.createRigidArea(new Dimension(14, 0)));
        sortPanel.add(checkPanel);
        sortPanel.add(Box.createRigidArea(new Dimension(4, 0)));
        sortPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), title));
        return sortPanel;
    }

    private JPanel buildButtonPanel() {
        ButtonPanel buttonPanel = new ButtonPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        JButton okButton = new JButton("OK");
        JButton cancel = new JButton("Cancel");
        okButton.setMnemonic(79);
        cancel.setMnemonic(67);
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SortDescriptor[] sorters = new SortDescriptor[SortBox.this.sortItems];
                for (int item = 0; item < SortBox.this.sortItems; ++item) {
                    sorters[item] = new SortDescriptor(SortBox.this.sortBox[item].getSelectedIndex(), SortBox.this.ascendingButton[item].isSelected() ? 1 : 0);
                }
                SortBox.this.parent.setSortDescriptors(sorters);
                SortBox.this.dispose();
            }
        });
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                SortBox.this.dispose();
            }
        });
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(okButton);
        if (!UIManager.getSystemLookAndFeelClassName().equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel")) {
            buttonPanel.add(Box.createRigidArea(new Dimension(10, 0)));
        }
        buttonPanel.add(cancel);
        if (!UIManager.getSystemLookAndFeelClassName().equals("com.sun.java.swing.plaf.motif.MotifLookAndFeel")) {
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 14));
        } else {
            buttonPanel.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 7));
        }
        return buttonPanel;
    }
}

