/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class EventSummaryPage
extends KFrame
implements SortInterface {
    KTable eventTable;
    EventTableModel eventTableModel;
    EventDatabaseUpdateListener eventDatabaseUpdateListener;
    ArrayList eventList;
    EventDatabase eventDatabase;
    AbstractMessageHandler messageHandler;
    Object[] defaultColumns;
    ArrayList sortedList;
    SortDescriptor[] sortDescriptors;
    JLabel eventCountLabel;
    static EventSummaryPage eventSummaryPage;
    static DatabaseManager myDatabaseManager;

    public EventSummaryPage(DatabaseManager databaseManager, String title) {
        myDatabaseManager = databaseManager;
        this.eventDatabase = EventSummaryPage.myDatabaseManager.eventDatabase;
        this.beginFrameInit(databaseManager, title);
        this.loadPreferences();
        this.buildMenus();
        this.buildTable();
        this.buildStatusBar();
        this.eventDatabaseUpdateListener = new EventDatabaseUpdateListener();
        this.eventDatabase.addUpdateListener(this.eventDatabaseUpdateListener);
        this.eventDatabaseUpdateListener.run();
        this.savePreferences();
        this.completeFrameInit();
    }

    private void savePreferences() {
        int index;
        String columns = "";
        TableColumnModel tableColumnModel = this.eventTable.getColumnModel();
        int count = tableColumnModel.getColumnCount();
        for (index = 0; index < tableColumnModel.getColumnCount(); ++index) {
            columns = index != tableColumnModel.getColumnCount() - 1 ? columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim() + "," : columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim();
        }
        columns.trim();
        this.preferences.put("Table Columns", columns);
        for (index = 0; index < 1; ++index) {
            this.preferences.put("Table Sort Field" + index, EventDescriptor.fieldNames[this.sortDescriptors[index].field]);
            this.preferences.put("Table Sort Direction" + index, this.sortDescriptors[index].direction == 1 ? "Ascending" : "Descending");
        }
    }

    private void loadPreferences() {
        String[] fieldNames = EventDescriptor.fieldNames;
        ArrayList<String> fieldList = new ArrayList<String>();
        while (true) {
            int endIndex;
            String columns = "EventDate,EventTime,EventSource,EventType,EventLevel,EventMessage";
            int startIndex = 0;
            do {
                if ((endIndex = columns.indexOf(",", startIndex)) == -1) {
                    endIndex = columns.length();
                }
                String columnName = columns.substring(startIndex, endIndex);
                for (int index = 0; index < fieldNames.length; ++index) {
                    if (!fieldNames[index].trim().equals(columnName.trim())) continue;
                    fieldList.add(columnName);
                }
            } while ((startIndex = endIndex + 1) < columns.length());
            if (fieldList.size() > 0) break;
            this.preferences.put("Table Columns", "EventDate,EventTime,EventSource,EventType,EventLevel,EventMessage");
        }
        this.defaultColumns = new Object[fieldList.size()];
        for (int index = 0; index < fieldList.size(); ++index) {
            this.defaultColumns[index] = fieldList.get(index);
        }
        String[] defaultFields = new String[]{"EventDate"};
        String[] defaultDirection = new String[]{"Ascending"};
        this.sortDescriptors = new SortDescriptor[1];
        block4: for (int sorter = 0; sorter < this.sortDescriptors.length; ++sorter) {
            String fields = this.preferences.get("Table Sort Field" + sorter, defaultFields[sorter]);
            if (fields.equals("Event")) {
                fields = "EventDate";
            }
            String direction = this.preferences.get("Table Sort Direction" + sorter, defaultDirection[sorter]);
            for (int index = 0; index < fieldNames.length; ++index) {
                if (!fieldNames[index].equals(fields)) continue;
                this.sortDescriptors[sorter] = new SortDescriptor(index, direction.equals("Ascending") ? 1 : 0);
                continue block4;
            }
        }
    }

    protected void closeFrame() {
        this.eventDatabase.removeUpdateListener(this.eventDatabaseUpdateListener);
        this.savePreferences();
        this.completeFrameClosure();
    }

    private void buildTable() {
        this.eventList = this.eventDatabase.getEventList();
        this.eventTableModel = new EventTableModel();
        this.eventTable = new KTable(this.eventTableModel, 24);
        this.eventTable.setSelectionMode(0);
        this.eventTable.getColumnModel().addColumnModelListener(new EventTableColumnModelListener());
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = EventSummaryPage.this.eventTable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = EventSummaryPage.this.eventTable.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 2 && column != -1) {
                    int count;
                    SortDescriptor[] sorters = EventSummaryPage.this.sortDescriptors;
                    SortDescriptor sorter = sorters[0];
                    String name = EventSummaryPage.this.eventTableModel.getColumnName(column);
                    for (count = 0; count < EventDescriptor.fieldNames.length && !name.trim().equalsIgnoreCase(EventDescriptor.fieldNames[count]); ++count) {
                    }
                    if (count < EventDescriptor.fieldNames.length) {
                        int description = sorter.field;
                        if (description != count) {
                            for (int offset = 1; offset >= 0; --offset) {
                                sorters[offset + 1].field = sorters[offset].field;
                                sorters[offset + 1].direction = sorters[offset].direction;
                            }
                            sorter.field = count;
                            sorter.direction = 1;
                        } else {
                            sorter.direction = sorter.direction == 1 ? 0 : 1;
                        }
                        EventSummaryPage.this.setSortDescriptors(sorters);
                    }
                }
            }
        };
        this.eventTable.addMouseListener(new MouseTableListener());
        JTableHeader th = this.eventTable.getTableHeader();
        th.addMouseListener(listMouseListener);
        DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)this.eventTable.getTableHeader().getDefaultRenderer();
        renderer.setHorizontalAlignment(2);
        JScrollPane scrollPane = new JScrollPane(this.eventTable);
        scrollPane.setAlignmentX(0.0f);
        scrollPane.getViewport().setBackground(this.eventTable.getBackground());
        this.getContentPane().add((Component)scrollPane, "Center");
    }

    private void buildMenus() {
        JMenuItem exitItem = new JMenuItem("Exit", 88);
        exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EventSummaryPage.this.closeFrame();
            }
        });
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        fileMenu.add(exitItem);
        JMenuItem fieldsItem = new JMenuItem("Fields...", 70);
        JMenuItem eventLogOptionsItem = new JMenuItem("Event Log Options", 69);
        JMenuItem turnOffAlertItem = new JMenuItem("Turn off current alert", 65);
        fieldsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new FieldsBox(EventSummaryPage.this, EventSummaryPage.this.eventTable, EventSummaryPage.this.eventTableModel);
            }
        });
        eventLogOptionsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                EventOptionsFrame eventOptionsFrame = EventOptionsFrame.getEventOptionsFrame(myDatabaseManager);
                ((Component)eventOptionsFrame).setVisible(true);
            }
        });
        turnOffAlertItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                IconAlert.getIconAlert();
                IconAlert.StopIconAlert();
            }
        });
        JMenu optionsMenu = new JMenu("Options");
        optionsMenu.setMnemonic(79);
        optionsMenu.add(fieldsItem);
        JMenuBar menubar = new JMenuBar();
        menubar.add(fileMenu);
        menubar.add(optionsMenu);
        this.setJMenuBar(menubar);
    }

    private void buildStatusBar() {
        this.eventCountLabel = new JLabel(" Event Count: 0");
        this.eventCountLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.getContentPane().add((Component)this.eventCountLabel, "South");
    }

    public synchronized void setSortDescriptors(SortDescriptor[] newSorterDescriptors) {
        this.sortDescriptors = newSorterDescriptors;
        this.eventDatabaseUpdateListener.run();
        this.savePreferences();
    }

    class EventTableModel
    extends KTableModel {
        public EventTableModel() {
            this.setColumns(EventDescriptor.fieldNames, EventDescriptor.maxFieldText);
        }

        public Object[] getDefaultColumns() {
            return EventSummaryPage.this.defaultColumns;
        }

        public void updateDisplay() {
            if (EventSummaryPage.this.eventList.size() > 0) {
                this.fireTableRowsInserted(0, EventSummaryPage.this.eventList.size() - 1);
            } else {
                this.fireTableRowsDeleted(0, 0);
            }
        }

        public int getRowCount() {
            return EventSummaryPage.this.eventList.size();
        }

        public Object getValueAt(int row, int column) {
            String value;
            if (row >= EventSummaryPage.this.eventList.size()) {
                value = "";
            } else {
                EventDescriptor event = (EventDescriptor)EventSummaryPage.this.eventList.get(row);
                value = event.getFieldValue(column);
                if (value.equalsIgnoreCase("N/A")) {
                    if (!EventDescriptor.fieldNames[column].equals("EventSource")) {
                        value = "";
                    }
                }
            }
            return " " + value;
        }
    }

    class MouseTableListener
    extends MouseAdapter {
        MouseTableListener() {
        }

        public void mouseReleased(MouseEvent evt) {
            int mouseSelectedRow;
            if (evt.getModifiers() == 4 && (mouseSelectedRow = EventSummaryPage.this.eventTable.rowAtPoint(new Point(evt.getX(), evt.getY()))) < EventSummaryPage.this.eventTable.getRowCount()) {
                EventSummaryPage.this.eventTable.addRowSelectionInterval(mouseSelectedRow, mouseSelectedRow);
                EventDescriptor eventDescriptor = (EventDescriptor)EventSummaryPage.this.eventList.get(mouseSelectedRow);
            }
        }
    }

    protected class EventDatabaseUpdateListener
    implements Runnable {
        boolean active = true;

        public void terminate() {
            this.active = false;
        }

        public void run() {
            if (!this.active) {
                return;
            }
            EventSummaryPage.this.eventList = EventSummaryPage.this.eventDatabase.getEventList();
            EventSummaryPage.this.eventTableModel.updateDisplay();
            EventDatabase cfr_ignored_0 = EventSummaryPage.this.eventDatabase;
            EventSummaryPage.this.eventCountLabel.setText(" Event Count: " + EventDatabase.EventTableIndex);
        }
    }

    class EventTableColumnModelListener
    implements TableColumnModelListener {
        EventTableColumnModelListener() {
        }

        public void columnAdded(TableColumnModelEvent e) {
            EventSummaryPage.this.savePreferences();
        }

        public void columnMoved(TableColumnModelEvent e) {
            EventSummaryPage.this.savePreferences();
        }

        public void columnRemoved(TableColumnModelEvent e) {
        }

        public void columnMarginChanged(ChangeEvent e) {
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }
}

