/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class DeviceSummaryPage
extends KFrame
implements SortInterface {
    KTable deviceTable;
    DeviceManagerTableModel deviceTableModel;
    DeviceDatabaseUpdateListener deviceDatabaseUpdateListener;
    ArrayList deviceList;
    DeviceDatabase deviceDatabase;
    AbstractMessageHandler messageHandler;
    Object[] defaultColumns;
    ArrayList sortedList;
    SortDescriptor[] sortDescriptors;
    JLabel deviceCountLabel;
    static /* synthetic */ Class class$java$lang$String;

    public DeviceSummaryPage(DatabaseManager databaseManager, String title) {
        this.beginFrameInit(databaseManager, title);
        this.deviceDatabase = databaseManager.deviceDatabase;
        this.loadPreferences();
        this.buildMenus();
        this.buildTable();
        this.buildStatusBar();
        this.deviceDatabaseUpdateListener = new DeviceDatabaseUpdateListener();
        this.deviceDatabase.addUpdateListener(this.deviceDatabaseUpdateListener);
        this.deviceDatabaseUpdateListener.run();
        this.savePreferences();
        this.completeFrameInit();
    }

    private void savePreferences() {
        int index;
        String columns = "";
        TableColumnModel tableColumnModel = this.deviceTable.getColumnModel();
        int count = tableColumnModel.getColumnCount();
        for (index = 0; index < tableColumnModel.getColumnCount(); ++index) {
            columns = index != tableColumnModel.getColumnCount() - 1 ? columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim() + "," : columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim();
        }
        columns.trim();
        this.preferences.put("Table Columns", columns);
        for (index = 0; index < 1; ++index) {
            this.preferences.put("Table Sort Field" + index, DeviceDescriptor.fieldNames[this.sortDescriptors[index].field]);
            this.preferences.put("Table Sort Direction" + index, this.sortDescriptors[index].direction == 1 ? "Ascending" : "Descending");
        }
    }

    private void loadPreferences() {
        String[] fieldNames = DeviceDescriptor.fieldNames;
        ArrayList<String> fieldList = new ArrayList<String>();
        while (true) {
            int endIndex;
            String columns = this.preferences.get("Table Columns", "Path ID, Target ID,Status,Capacity,Model,Version");
            int startIndex = 0;
            do {
                if ((endIndex = columns.indexOf(",", startIndex)) == -1) {
                    endIndex = columns.length();
                }
                String columnName = columns.substring(startIndex, endIndex);
                for (int index = 0; index < fieldNames.length; ++index) {
                    if (!fieldNames[index].trim().equals(columnName.trim())) continue;
                    fieldList.add(columnName);
                }
            } while ((startIndex = endIndex + 1) < columns.length());
            if (fieldList.size() > 0) break;
            this.preferences.put("Table Columns", "Path ID, Target ID,Status,Capacity,Model,Version");
        }
        this.defaultColumns = new Object[fieldList.size()];
        for (int index = 0; index < fieldList.size(); ++index) {
            this.defaultColumns[index] = fieldList.get(index);
        }
        String[] defaultFields = new String[]{"Device"};
        String[] defaultDirection = new String[]{"Ascending"};
        this.sortDescriptors = new SortDescriptor[1];
        block4: for (int sorter = 0; sorter < this.sortDescriptors.length; ++sorter) {
            String fields = this.preferences.get("Table Sort Field" + sorter, defaultFields[sorter]);
            String direction = this.preferences.get("Table Sort Direction" + sorter, defaultDirection[sorter]);
            for (int index = 0; index < fieldNames.length; ++index) {
                if (!fieldNames[index].equals(fields)) continue;
                this.sortDescriptors[sorter] = new SortDescriptor(index, direction.equals("Ascending") ? 1 : 0);
                continue block4;
            }
        }
    }

    protected void closeFrame() {
        this.deviceDatabase.removeUpdateListener(this.deviceDatabaseUpdateListener);
        this.completeFrameClosure();
    }

    private void buildTable() {
        this.deviceList = this.getDeviceList();
        this.deviceTableModel = new DeviceManagerTableModel();
        this.deviceTable = new KTable(this.deviceTableModel, 24);
        this.deviceTable.setSelectionMode(0);
        DefaultTableCellRenderer renderer = (DefaultTableCellRenderer)this.deviceTable.getTableHeader().getDefaultRenderer();
        renderer.setHorizontalAlignment(2);
        this.deviceTable.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = DeviceSummaryPage.class$("java.lang.String")) : class$java$lang$String, new NewCellRenderer());
        this.deviceTable.getColumnModel().addColumnModelListener(new DeviceTableColumnModelListener());
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = DeviceSummaryPage.this.deviceTable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = DeviceSummaryPage.this.deviceTable.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 2 && column != -1) {
                    int count;
                    SortDescriptor[] sorters = DeviceSummaryPage.this.sortDescriptors;
                    SortDescriptor sorter = sorters[0];
                    String name = DeviceSummaryPage.this.deviceTableModel.getColumnName(column);
                    for (count = 0; count < DeviceDescriptor.fieldNames.length && !name.trim().equalsIgnoreCase(DeviceDescriptor.fieldNames[count]); ++count) {
                    }
                    if (count < DeviceDescriptor.fieldNames.length) {
                        int description = sorter.field;
                        if (description != count) {
                            for (int offset = 1; offset >= 0; --offset) {
                                sorters[offset + 1].field = sorters[offset].field;
                                sorters[offset + 1].direction = sorters[offset].direction;
                            }
                            sorter.field = count;
                            sorter.direction = 1;
                        } else {
                            sorter.direction = sorter.direction == 1 ? 0 : 1;
                        }
                        DeviceSummaryPage.this.setSortDescriptors(sorters);
                    }
                }
            }
        };
        this.deviceTable.addMouseListener(new MouseTableListener());
        JTableHeader th = this.deviceTable.getTableHeader();
        th.addMouseListener(listMouseListener);
        JScrollPane scrollPane = new JScrollPane(this.deviceTable);
        scrollPane.getViewport().setBackground(this.deviceTable.getBackground());
        this.getContentPane().add((Component)scrollPane, "Center");
    }

    private void buildMenus() {
        JMenuItem openItem = new JMenuItem("Open...", 79);
        JMenuItem saveItem = new JMenuItem("Save...", 83);
        JMenuItem printItem = new JMenuItem("Print...", 80);
        JMenuItem exitItem = new JMenuItem("Exit", 88);
        openItem.setEnabled(false);
        saveItem.setEnabled(false);
        printItem.setEnabled(false);
        exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DeviceSummaryPage.this.closeFrame();
            }
        });
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        fileMenu.add(exitItem);
        JMenuItem sortingItem = new JMenuItem("Sorting...", 83);
        JMenuItem fieldsItem = new JMenuItem("Fields...", 70);
        fieldsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new FieldsBox(DeviceSummaryPage.this, DeviceSummaryPage.this.deviceTable, DeviceSummaryPage.this.deviceTableModel);
            }
        });
        sortingItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new SortBox(DeviceSummaryPage.this, DeviceDescriptor.fieldNames, DeviceSummaryPage.this.sortDescriptors);
            }
        });
        JMenu optionsMenu = new JMenu("Options");
        optionsMenu.setMnemonic(79);
        optionsMenu.add(sortingItem);
        optionsMenu.add(fieldsItem);
        JMenuBar menubar = new JMenuBar();
        menubar.add(fileMenu);
        menubar.add(optionsMenu);
        this.setJMenuBar(menubar);
    }

    private void buildStatusBar() {
        this.deviceCountLabel = new JLabel(" Device Count: 0");
        this.deviceCountLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.getContentPane().add((Component)this.deviceCountLabel, "South");
    }

    public synchronized void setSortDescriptors(SortDescriptor[] newSorterDescriptors) {
        this.sortDescriptors = newSorterDescriptors;
        this.deviceDatabaseUpdateListener.run();
        this.savePreferences();
    }

    public synchronized ArrayList getDeviceList() {
        ArrayList newDeviceList = this.deviceDatabase.getDeviceList();
        ArrayList<DeviceDescriptor> sortedList = new ArrayList<DeviceDescriptor>();
        for (int sourceIndex = 0; sourceIndex < newDeviceList.size(); ++sourceIndex) {
            DeviceDescriptor destDevice;
            int result;
            int destIndex;
            DeviceDescriptor sourceDevice = (DeviceDescriptor)newDeviceList.get(sourceIndex);
            for (destIndex = 0; destIndex < sortedList.size() && (result = sourceDevice.compare(destDevice = (DeviceDescriptor)sortedList.get(destIndex), this.sortDescriptors[0])) < 1; ++destIndex) {
            }
            sortedList.add(destIndex, sourceDevice);
        }
        return sortedList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class NewCellRenderer
    extends DefaultTableCellRenderer {
        NewCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component c = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (hasFocus) {
                if (table.getRowSelectionAllowed() && table.getSelectedRow() != -1) {
                    this.setBorder(BorderFactory.createLineBorder(table.getSelectionBackground()));
                } else {
                    this.setBorder(BorderFactory.createLineBorder(table.getBackground()));
                }
            }
            int pathId = 0;
            int targetId = 0;
            String pathIdStr = "";
            String targetIdStr = "";
            int columns = table.getColumnCount();
            TableColumnModel columnModel = table.getColumnModel();
            boolean pathIdFound = false;
            boolean targetIdFound = false;
            for (column = 0; column < columns; ++column) {
                String header = ((String)columnModel.getColumn(column).getHeaderValue()).trim();
                if (header.equals("Path ID")) {
                    pathIdStr = (String)table.getValueAt(row, column);
                    pathIdFound = true;
                } else if (header.equals("Target ID")) {
                    targetIdStr = (String)table.getValueAt(row, column);
                    targetIdFound = true;
                }
                if (pathIdFound && targetIdFound) break;
            }
            try {
                pathId = Integer.parseInt(pathIdStr.trim());
                targetId = Integer.parseInt(targetIdStr.trim());
            }
            catch (Exception e) {
                // empty catch block
            }
            ArrayList deviceList = DeviceSummaryPage.this.deviceDatabase.getDeviceList();
            boolean passThruFound = false;
            for (int device = 0; device < deviceList.size(); ++device) {
                DeviceDescriptor deviceDescriptor = (DeviceDescriptor)deviceList.get(device);
                if (deviceDescriptor.pathId != pathId || deviceDescriptor.targetId != targetId || !deviceDescriptor.passThru) continue;
                passThruFound = true;
                break;
            }
            if (passThruFound) {
                c.setBackground(GlobalConstants.passThruColor);
                c.setForeground(Color.black);
            } else {
                c.setBackground(table.getBackground());
                c.setForeground(table.getForeground());
            }
            if (isSelected) {
                c.setBackground(table.getSelectionBackground());
                c.setForeground(table.getSelectionForeground());
            }
            return c;
        }
    }

    class DeviceManagerTableModel
    extends KTableModel {
        public DeviceManagerTableModel() {
            this.setColumns(DeviceDescriptor.fieldNames, DeviceDescriptor.maxFieldText);
        }

        public Object[] getDefaultColumns() {
            return DeviceSummaryPage.this.defaultColumns;
        }

        public void updateDisplay() {
            if (DeviceSummaryPage.this.deviceList.size() > 0) {
                this.fireTableRowsInserted(0, DeviceSummaryPage.this.deviceList.size() - 1);
            } else {
                this.fireTableRowsDeleted(0, 0);
            }
        }

        public int getRowCount() {
            return DeviceSummaryPage.this.deviceList.size();
        }

        public Object getValueAt(int row, int column) {
            String value;
            if (row >= DeviceSummaryPage.this.deviceList.size()) {
                value = "";
            } else {
                DeviceDescriptor device = (DeviceDescriptor)DeviceSummaryPage.this.deviceList.get(row);
                value = device.getFieldValue(column);
                if (value.equalsIgnoreCase("N/A")) {
                    value = "";
                }
            }
            return " " + value;
        }
    }

    class MouseTableListener
    extends MouseAdapter {
        MouseTableListener() {
        }

        public void mouseReleased(MouseEvent evt) {
            int mouseSelectedRow;
            if (evt.getModifiers() == 4 && (mouseSelectedRow = DeviceSummaryPage.this.deviceTable.rowAtPoint(new Point(evt.getX(), evt.getY()))) < DeviceSummaryPage.this.deviceTable.getRowCount()) {
                DeviceSummaryPage.this.deviceTable.addRowSelectionInterval(mouseSelectedRow, mouseSelectedRow);
                DeviceDescriptor deviceDescriptor = (DeviceDescriptor)DeviceSummaryPage.this.deviceList.get(mouseSelectedRow);
            }
        }

        public void mousePressed(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent e) {
        }
    }

    protected class DeviceDatabaseUpdateListener
    implements Runnable {
        boolean active = true;

        public void terminate() {
            this.active = false;
        }

        public void run() {
            if (!this.active) {
                return;
            }
            ArrayList newDeviceList = DeviceSummaryPage.this.getDeviceList();
            if (DeviceSummaryPage.this.deviceTable.getSelectedRow() == -1) {
                DeviceSummaryPage.this.deviceList = newDeviceList;
                DeviceSummaryPage.this.deviceTableModel.updateDisplay();
            } else {
                int newRow;
                int selectedIndex;
                int oldListSize = DeviceSummaryPage.this.deviceList.size();
                int oldTableSize = DeviceSummaryPage.this.deviceTableModel.getRowCount();
                int[] selectedRows = DeviceSummaryPage.this.deviceTable.getSelectedRows();
                for (selectedIndex = 0; selectedIndex < selectedRows.length; ++selectedIndex) {
                    DeviceDescriptor deviceDescriptor = (DeviceDescriptor)DeviceSummaryPage.this.deviceList.get(selectedRows[selectedIndex]);
                    boolean found = false;
                    for (newRow = 0; newRow < newDeviceList.size(); ++newRow) {
                        DeviceDescriptor newDeviceDescriptor = (DeviceDescriptor)newDeviceList.get(newRow);
                        if (!newDeviceDescriptor.serialNumber.equals(deviceDescriptor.serialNumber)) continue;
                        found = true;
                        break;
                    }
                    selectedRows[selectedIndex] = found ? newRow : -1;
                }
                DeviceSummaryPage.this.deviceList = newDeviceList;
                DeviceSummaryPage.this.deviceTable.clearSelection();
                DeviceSummaryPage.this.deviceTableModel.updateDisplay();
                for (selectedIndex = 0; selectedIndex < selectedRows.length; ++selectedIndex) {
                    newRow = selectedRows[selectedIndex];
                    if (newRow == -1) continue;
                    DeviceSummaryPage.this.deviceTable.addRowSelectionInterval(newRow, newRow);
                }
            }
            DeviceSummaryPage.this.deviceCountLabel.setText(" Device Count: " + DeviceSummaryPage.this.deviceList.size());
        }
    }

    class DeviceTableColumnModelListener
    implements TableColumnModelListener {
        DeviceTableColumnModelListener() {
        }

        public void columnAdded(TableColumnModelEvent e) {
            DeviceSummaryPage.this.savePreferences();
        }

        public void columnMoved(TableColumnModelEvent e) {
            DeviceSummaryPage.this.savePreferences();
        }

        public void columnRemoved(TableColumnModelEvent e) {
        }

        public void columnMarginChanged(ChangeEvent e) {
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }
}

