/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class TaskManagerPage
extends KFrame
implements ScheduleTaskInterface,
SortInterface {
    KTable taskTable;
    TaskManagerTableModel taskTableModel;
    TaskDatabaseUpdateListener taskDatabaseUpdateListener;
    CommLinkUpdateListener commLinkUpdateListener;
    CommManager commManager;
    TaskDatabase taskDatabase;
    JPopupMenu taskPopupMenu;
    AbstractAction informationAction;
    AbstractAction modifyAction;
    AbstractAction suspendAction;
    AbstractAction resumeAction;
    AbstractAction cancelAction;
    AbstractAction deleteAction;
    JCheckBoxMenuItem gridLinesItem;
    JLabel taskCountLabel;
    ArrayList taskList;
    AbstractMessageHandler messageHandler;
    Object[] defaultColumns;
    int waitCount;
    ArrayList sortedList;
    SortDescriptor[] sortDescriptors;

    public TaskManagerPage(DatabaseManager databaseManager, String title) {
        this.beginFrameInit(databaseManager, title);
        this.taskDatabase = databaseManager.taskDatabase;
        this.commManager = databaseManager.commManager;
        this.taskList = new ArrayList();
        this.sortedList = new ArrayList();
        this.sortDescriptors = new SortDescriptor[1];
        this.waitCount = 0;
        this.loadProperties();
        this.buildMenus();
        this.buildTable();
        this.buildStatusBar();
        this.taskDatabaseUpdateListener = new TaskDatabaseUpdateListener();
        this.taskDatabase.addUpdateListener(this.taskDatabaseUpdateListener);
        this.taskDatabaseUpdateListener.run();
        CommLinkUpdateListener commLinkUpdateListener = new CommLinkUpdateListener();
        this.commManager.addUpdateListener(commLinkUpdateListener);
        commLinkUpdateListener.run();
        this.updateTaskMenuItemsState();
        this.saveProperties();
        this.completeFrameInit();
    }

    private void saveProperties() {
        int index;
        String columns = "";
        TableColumnModel tableColumnModel = this.taskTable.getColumnModel();
        int count = tableColumnModel.getColumnCount();
        for (index = 0; index < tableColumnModel.getColumnCount(); ++index) {
            columns = index != tableColumnModel.getColumnCount() - 1 ? columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim() + "," : columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim();
        }
        columns.trim();
        this.preferences.put("Table Columns", columns);
        for (index = 0; index < 1; ++index) {
            this.preferences.put("Table Sort Field" + index, TaskDescriptor.fieldNames[this.sortDescriptors[index].field]);
            this.preferences.put("Table Sort Direction" + index, this.sortDescriptors[index].direction == 1 ? "Ascending" : "Descending");
        }
    }

    private void loadProperties() {
        ArrayList<String> fieldList = new ArrayList<String>();
        while (true) {
            int endIndex;
            String columns = this.preferences.get("Table Columns", "Task,Operation,Parameters,Status,Priority,Progress,Start Time,End Time,Remaining");
            int startIndex = 0;
            do {
                if ((endIndex = columns.indexOf(",", startIndex)) == -1) {
                    endIndex = columns.length();
                }
                String columnName = columns.substring(startIndex, endIndex);
                for (int index = 0; index < TaskDescriptor.fieldNames.length; ++index) {
                    if (!TaskDescriptor.fieldNames[index].trim().equals(columnName.trim())) continue;
                    fieldList.add(columnName);
                }
            } while ((startIndex = endIndex + 1) < columns.length());
            if (fieldList.size() > 0) break;
            this.preferences.put("Table Columns", "Task ID,Operation,Parameters,State,Start Time,End Time");
        }
        this.defaultColumns = new Object[fieldList.size()];
        for (int index = 0; index < fieldList.size(); ++index) {
            this.defaultColumns[index] = fieldList.get(index);
        }
        String[] defaultFields = new String[]{"End Time"};
        String[] defaultDirection = new String[]{"Descending"};
        block4: for (int sorter = 0; sorter < this.sortDescriptors.length; ++sorter) {
            this.preferences.put("Table Columns", "Task ID,Operation,Parameters,State,Start Time,End Time");
            String fields = this.preferences.get("Table Sort Field" + sorter, defaultFields[sorter]);
            String direction = this.preferences.get("Table Sort Direction" + sorter, defaultDirection[sorter]);
            for (int index = 0; index < TaskDescriptor.fieldNames.length; ++index) {
                if (!TaskDescriptor.fieldNames[index].equals(fields)) continue;
                this.sortDescriptors[sorter] = new SortDescriptor(index, direction.equals("Ascending") ? 1 : 0);
                continue block4;
            }
        }
    }

    private void buildMenus() {
        JMenuItem openItem = new JMenuItem("Open...", 79);
        JMenuItem saveItem = new JMenuItem("Save...", 83);
        JMenuItem printItem = new JMenuItem("Print...", 80);
        JMenuItem exitItem = new JMenuItem("Exit", 88);
        openItem.setEnabled(false);
        saveItem.setEnabled(false);
        printItem.setEnabled(false);
        exitItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TaskManagerPage.this.closeFrame();
            }
        });
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic(70);
        fileMenu.add(openItem);
        fileMenu.add(saveItem);
        fileMenu.add(printItem);
        fileMenu.addSeparator();
        fileMenu.add(exitItem);
        JMenuItem sortingItem = new JMenuItem("Sorting...", 83);
        JMenuItem fieldsItem = new JMenuItem("Fields...", 70);
        this.gridLinesItem = new JCheckBoxMenuItem("Grid Lines", true);
        fieldsItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new FieldsBox(TaskManagerPage.this, TaskManagerPage.this.taskTable, TaskManagerPage.this.taskTableModel);
            }
        });
        sortingItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                new SortBox(TaskManagerPage.this, TaskDescriptor.fieldNames, TaskManagerPage.this.sortDescriptors);
                TaskManagerPage.this.taskDatabaseUpdateListener.run();
            }
        });
        this.gridLinesItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TaskManagerPage.this.taskTable.setShowGrid(TaskManagerPage.this.gridLinesItem.getState());
            }
        });
        JMenu optionsMenu = new JMenu("Options");
        optionsMenu.setMnemonic(79);
        optionsMenu.add(sortingItem);
        optionsMenu.add(fieldsItem);
        this.modifyAction = new AbstractAction("Modify..."){

            public void actionPerformed(ActionEvent e) {
                int[] selectedRows = TaskManagerPage.this.taskTable.getSelectedRows();
                TaskManagerPage.this.getContentPane().update(TaskManagerPage.this.getContentPane().getGraphics());
                new ModifyTaskBox(TaskManagerPage.this.databaseManager, "Modify Task Parameters", (TaskDescriptor)((TaskDescriptor)TaskManagerPage.this.taskList.get(selectedRows[0])).clone());
                TaskManagerPage.this.getContentPane().update(TaskManagerPage.this.getContentPane().getGraphics());
            }
        };
        this.suspendAction = new AbstractAction("Suspend..."){

            public void actionPerformed(ActionEvent e) {
                TaskManagerPage.this.performOperationOnSelectedTask("SuspendTask");
            }
        };
        this.resumeAction = new AbstractAction("Resume..."){

            public void actionPerformed(ActionEvent e) {
                TaskManagerPage.this.performOperationOnSelectedTask("ResumeTask");
            }
        };
        this.cancelAction = new AbstractAction("Cancel..."){

            public void actionPerformed(ActionEvent e) {
                TaskManagerPage.this.getContentPane().update(TaskManagerPage.this.getContentPane().getGraphics());
                int[] selectedRows = TaskManagerPage.this.taskTable.getSelectedRows();
                int reconfigCount = 0;
                for (int count = 0; count < selectedRows.length; ++count) {
                    TaskDescriptor taskDescriptor = (TaskDescriptor)TaskManagerPage.this.taskList.get(selectedRows[count]);
                    if (!taskDescriptor.operation.equals("Reconfigure RAID Group")) continue;
                    ++reconfigCount;
                }
                int answer = reconfigCount == 0 ? (selectedRows.length == 1 ? JOptionPane.showConfirmDialog(TaskManagerPage.this, "Are you sure you want to cancel this task?", "Cancel Task Verification", 0) : JOptionPane.showConfirmDialog(TaskManagerPage.this, "Are you sure you want to cancel these tasks?", "Cancel Task Verification", 0)) : (selectedRows.length == 1 ? JOptionPane.showConfirmDialog(TaskManagerPage.this, "Canceling this task will cause the RAID Group being\nreconfigured to be deleted (losing all its data)\nAre you sure you want to cancel this task?", "Cancel Task Verification", 0) : (reconfigCount == 1 ? JOptionPane.showConfirmDialog(TaskManagerPage.this, "Canceling one of these tasks will cause a RAID Group\nbeing reconfigured to be deleted (losing all its data)\nAre you sure you want to cancel these tasks?", "Cancel Task Verification", 0) : JOptionPane.showConfirmDialog(TaskManagerPage.this, "Canceling these tasks will cause RAID Groups being\nreconfigured to be deleted (losing all their data)\nAre you sure you want to cancel these tasks?", "Cancel Task Verification", 0)));
                if (answer == 0) {
                    TaskManagerPage.this.performOperationOnSelectedTask("CancelTask");
                }
            }
        };
        this.deleteAction = new AbstractAction("Delete..."){

            public void actionPerformed(ActionEvent e) {
                int answer = JOptionPane.showConfirmDialog(TaskManagerPage.this, "Are you sure you want to delete specified task(s)?", "Delete Task Verification", 0);
                if (answer == 0) {
                    TaskManagerPage.this.performOperationOnSelectedTask("DeleteTask");
                }
            }
        };
        JMenuItem modifyItem = new JMenuItem(this.modifyAction);
        JMenuItem suspendItem = new JMenuItem(this.suspendAction);
        JMenuItem resumeItem = new JMenuItem(this.resumeAction);
        JMenuItem cancelItem = new JMenuItem(this.cancelAction);
        JMenuItem deleteItem = new JMenuItem(this.deleteAction);
        modifyItem.setMnemonic(77);
        suspendItem.setMnemonic(83);
        resumeItem.setMnemonic(82);
        cancelItem.setMnemonic(67);
        deleteItem.setMnemonic(68);
        JMenu taskMenu = new JMenu("Task");
        taskMenu.setMnemonic(84);
        taskMenu.add(modifyItem);
        taskMenu.addSeparator();
        taskMenu.add(suspendItem);
        taskMenu.add(resumeItem);
        taskMenu.add(cancelItem);
        taskMenu.addSeparator();
        taskMenu.add(deleteItem);
        JMenuItem modifyPopupItem = new JMenuItem(this.modifyAction);
        JMenuItem suspendPopupItem = new JMenuItem(this.suspendAction);
        JMenuItem resumePopupItem = new JMenuItem(this.resumeAction);
        JMenuItem cancelPopupItem = new JMenuItem(this.cancelAction);
        JMenuItem deletePopupItem = new JMenuItem(this.deleteAction);
        this.taskPopupMenu = new JPopupMenu();
        this.taskPopupMenu.add(modifyPopupItem);
        this.taskPopupMenu.addSeparator();
        this.taskPopupMenu.add(suspendPopupItem);
        this.taskPopupMenu.add(resumePopupItem);
        this.taskPopupMenu.add(cancelPopupItem);
        this.taskPopupMenu.addSeparator();
        this.taskPopupMenu.add(deletePopupItem);
        JMenuBar menubar = new JMenuBar();
        menubar.add(fileMenu);
        menubar.add(optionsMenu);
        menubar.add(taskMenu);
        this.setJMenuBar(menubar);
    }

    public TaskDescriptor getSelectedTask() {
        return (TaskDescriptor)this.taskList.get(this.taskTable.getSelectedRow());
    }

    public int getSelectedRow() {
        return this.taskTable.getSelectedRow();
    }

    public int getRowCount() {
        return this.taskTable.getRowCount();
    }

    public boolean moveSelectedRowDown() {
        return this.taskTable.moveSelectedRowDown();
    }

    public boolean moveSelectedRowUp() {
        return this.taskTable.moveSelectedRowUp();
    }

    public synchronized void setSortDescriptors(SortDescriptor[] newSorterDescriptors) {
        this.sortDescriptors = newSorterDescriptors;
        this.taskDatabaseUpdateListener.run();
        this.saveProperties();
    }

    public synchronized ArrayList getTaskList() {
        ArrayList newTaskList = this.taskDatabase.getTaskList();
        ArrayList<TaskDescriptor> sortedList = new ArrayList<TaskDescriptor>();
        for (int sourceIndex = 0; sourceIndex < newTaskList.size(); ++sourceIndex) {
            TaskDescriptor destTask;
            int result;
            int destIndex;
            TaskDescriptor sourceTask = (TaskDescriptor)newTaskList.get(sourceIndex);
            for (destIndex = 0; destIndex < sortedList.size() && (result = sourceTask.compare(destTask = (TaskDescriptor)sortedList.get(destIndex), this.sortDescriptors[0])) < 1; ++destIndex) {
            }
            sortedList.add(destIndex, sourceTask);
        }
        return sortedList;
    }

    private void buildTable() {
        this.taskTableModel = new TaskManagerTableModel();
        this.taskTable = new KTable(this.taskTableModel, 24);
        this.taskTable.addMouseListener(new MouseTableListener());
        this.taskTable.addListSelectionListener(new TableSelectionListener());
        this.taskTable.getColumnModel().addColumnModelListener(new TaskTableColumnModelListener());
        if (this.taskList.size() > 0) {
            this.taskTable.changeSelection(0, 0, false, false);
        }
        JScrollPane scrollPane = new JScrollPane(this.taskTable);
        scrollPane.getViewport().setBackground(this.taskTable.getBackground());
        this.taskTable.setColumnSelectionAllowed(false);
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = TaskManagerPage.this.taskTable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = TaskManagerPage.this.taskTable.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 2 && column != -1) {
                    int count;
                    SortDescriptor[] sorters = TaskManagerPage.this.sortDescriptors;
                    SortDescriptor sorter = sorters[0];
                    String name = TaskManagerPage.this.taskTableModel.getColumnName(column);
                    for (count = 0; count < TaskDescriptor.fieldNames.length && !name.trim().equalsIgnoreCase(TaskDescriptor.fieldNames[count]); ++count) {
                    }
                    if (count < TaskDescriptor.fieldNames.length) {
                        int description = sorter.field;
                        if (description != count) {
                            for (int offset = 1; offset >= 0; --offset) {
                                sorters[offset + 1].field = sorters[offset].field;
                                sorters[offset + 1].direction = sorters[offset].direction;
                            }
                            sorter.field = count;
                            sorter.direction = 1;
                        } else {
                            sorter.direction = sorter.direction == 1 ? 0 : 1;
                        }
                        TaskManagerPage.this.setSortDescriptors(sorters);
                    }
                }
            }
        };
        JTableHeader th = this.taskTable.getTableHeader();
        th.addMouseListener(listMouseListener);
        this.getContentPane().add((Component)scrollPane, "Center");
        KeyAdapter myListener = new KeyAdapter(){

            public void keyPressed(KeyEvent anEvent) {
                if (anEvent.getKeyCode() == 10) {
                    anEvent.consume();
                }
            }
        };
        this.taskTable.addKeyListener(myListener);
    }

    private void buildStatusBar() {
        this.taskCountLabel = new JLabel(" Task Count: 0");
        this.taskCountLabel.setBorder(BorderFactory.createLoweredBevelBorder());
        this.getContentPane().add((Component)this.taskCountLabel, "South");
    }

    private synchronized void performOperationOnSelectedTask(String operation) {
        long minSequenceNumber = 0L;
        int[] selectedRows = this.taskTable.getSelectedRows();
        if (operation.equals("DeleteTask")) {
            minSequenceNumber = this.databaseManager.taskDatabase.getMinTaskNumber();
        }
        for (int count = 0; count < selectedRows.length; ++count) {
            TaskDescriptor taskDescriptor = (TaskDescriptor)this.taskList.get(selectedRows[count]);
            if (operation.equals("DeleteTask")) {
                if (taskDescriptor.valid) {
                    this.sendRequest(operation, taskDescriptor);
                    this.databaseManager.taskDatabase.deleteTask(Long.toString(taskDescriptor.task));
                    continue;
                }
                if (taskDescriptor.done && (!taskDescriptor.valid || taskDescriptor.task < minSequenceNumber)) {
                    this.databaseManager.taskDatabase.deleteTask(Long.toString(taskDescriptor.task));
                    continue;
                }
            }
            this.sendRequest(operation, taskDescriptor);
        }
    }

    private void sendRequest(String operation, TaskDescriptor taskDescriptor) {
        String request = "<si:Request><si:Type>" + operation + "</si:Type>" + "<si:Task>" + taskDescriptor.task + "</si:Task>" + "</si:Request>";
        AbstractMessageHandler responseMessageHandler = new AbstractMessageHandler(){

            public void handleMessage(Message message) {
                TaskManagerPage.this.clearCursorWait();
                XmlData xmlData = new XmlData(message.response);
                if (xmlData.getNextElement() && xmlData.element.equals("Fault")) {
                    FaultDescriptor faultDescriptor = new FaultDescriptor(xmlData.elementValue);
                    new ErrorMessageBox(TaskManagerPage.this, "The Requested Operation Failed: " + faultDescriptor.reason, "Task Manager Error");
                }
            }
        };
        this.setCursorWait();
        this.commManager.sendMessage("Execute", request, responseMessageHandler);
    }

    private synchronized void setCursorWait() {
        if (this.waitCount++ == 0) {
            this.setCursor(new Cursor(3));
        }
    }

    private synchronized void clearCursorWait() {
        if (--this.waitCount == 0) {
            this.setCursor(new Cursor(0));
        }
    }

    public synchronized void updateTaskSchedule(TaskSchedule taskSchedule) {
        TaskDescriptor taskDescriptor = (TaskDescriptor)this.taskList.get(this.taskTable.getSelectedRow());
        boolean differentPriority = taskSchedule.priority != Integer.parseInt(taskDescriptor.priority) ? true : true;
        boolean differentStartTime = taskSchedule.editStartTime && (taskSchedule.startImmediately || !taskSchedule.startTime.toString().equals(taskDescriptor.startTime));
        boolean differentRepeatInterval = taskSchedule.editRepeatInterval && !taskSchedule.repeatInterval.equals(taskDescriptor.interval);
        if (differentPriority || differentStartTime || differentRepeatInterval) {
            // empty if block
        }
    }

    protected void closeFrame() {
        this.taskDatabaseUpdateListener.terminate();
        this.taskDatabase.removeUpdateListener(this.taskDatabaseUpdateListener);
        this.commManager.removeUpdateListener(this.commLinkUpdateListener);
        this.completeFrameClosure();
    }

    private void updateTaskMenuItemsState() {
        boolean SUSPEND = true;
        int RESUME = 2;
        int CANCEL = 4;
        int DELETE = 8;
        int[] selectedRows = this.taskTable.getSelectedRows();
        if (selectedRows.length == 0) {
            this.modifyAction.setEnabled(false);
            this.suspendAction.setEnabled(false);
            this.resumeAction.setEnabled(false);
            this.cancelAction.setEnabled(false);
            this.deleteAction.setEnabled(false);
        } else if (selectedRows.length == 1) {
            TaskDescriptor task = (TaskDescriptor)this.taskList.get(selectedRows[0]);
            if (task.status.equalsIgnoreCase("Pending")) {
                this.modifyAction.setEnabled(true);
                this.suspendAction.setEnabled(true);
                this.resumeAction.setEnabled(false);
                this.cancelAction.setEnabled(true);
                this.deleteAction.setEnabled(false);
            } else if (task.status.equalsIgnoreCase("Active")) {
                this.modifyAction.setEnabled(true);
                this.resumeAction.setEnabled(false);
                this.deleteAction.setEnabled(false);
                if (task.operation.equals("Format Device")) {
                    this.suspendAction.setEnabled(false);
                    this.cancelAction.setEnabled(false);
                } else {
                    this.suspendAction.setEnabled(true);
                    this.cancelAction.setEnabled(true);
                }
            } else if (task.status.equalsIgnoreCase("Suspended")) {
                this.modifyAction.setEnabled(true);
                this.suspendAction.setEnabled(false);
                this.resumeAction.setEnabled(true);
                this.cancelAction.setEnabled(true);
                this.deleteAction.setEnabled(false);
            } else if (task.status.equalsIgnoreCase("Blocked")) {
                this.modifyAction.setEnabled(true);
                this.suspendAction.setEnabled(false);
                this.resumeAction.setEnabled(false);
                this.cancelAction.setEnabled(true);
                this.deleteAction.setEnabled(false);
            } else if (task.done) {
                this.modifyAction.setEnabled(false);
                this.suspendAction.setEnabled(false);
                this.resumeAction.setEnabled(false);
                this.cancelAction.setEnabled(false);
                this.deleteAction.setEnabled(true);
            } else {
                this.modifyAction.setEnabled(false);
                this.suspendAction.setEnabled(false);
                this.resumeAction.setEnabled(false);
                this.cancelAction.setEnabled(false);
                this.deleteAction.setEnabled(false);
            }
            if (task.operation.equals("Restore Redundancy")) {
                this.cancelAction.setEnabled(false);
            }
        } else {
            this.modifyAction.setEnabled(false);
            int options = 15;
            for (int index = 0; index < selectedRows.length; ++index) {
                if (selectedRows[index] >= this.taskList.size()) continue;
                TaskDescriptor taskDescriptor = (TaskDescriptor)this.taskList.get(selectedRows[index]);
                if (taskDescriptor.operation.equals("Format Device")) {
                    options &= 0xFFFFFFF8;
                } else if (taskDescriptor.operation.equals("Restore Redundancy")) {
                    options &= 0xFFFFFFFB;
                }
                if (taskDescriptor.status.equalsIgnoreCase("Pending") || taskDescriptor.status.equalsIgnoreCase("Active")) {
                    options &= 0xFFFFFFF5;
                    continue;
                }
                if (taskDescriptor.status.equalsIgnoreCase("Suspended")) {
                    options &= 0xFFFFFFF6;
                    continue;
                }
                if (taskDescriptor.status.equalsIgnoreCase("Blocked")) {
                    options &= 0xFFFFFFF4;
                    continue;
                }
                if (!taskDescriptor.done) continue;
                options &= 0xFFFFFFF8;
            }
            if ((options & 1) != 0) {
                this.suspendAction.setEnabled(true);
            } else {
                this.suspendAction.setEnabled(false);
            }
            if ((options & 2) != 0) {
                this.resumeAction.setEnabled(true);
            } else {
                this.resumeAction.setEnabled(false);
            }
            if ((options & 4) != 0) {
                this.cancelAction.setEnabled(true);
            } else {
                this.cancelAction.setEnabled(false);
            }
            if ((options & 8) != 0) {
                this.deleteAction.setEnabled(true);
            } else {
                this.deleteAction.setEnabled(false);
            }
        }
    }

    class TaskManagerTableModel
    extends KTableModel {
        public TaskManagerTableModel() {
            this.setColumns(TaskDescriptor.fieldNames, TaskDescriptor.fieldContentsMaxWidth);
        }

        public Object[] getDefaultColumns() {
            return TaskManagerPage.this.defaultColumns;
        }

        public void updateDisplay() {
            if (TaskManagerPage.this.taskList.size() > 0) {
                this.fireTableRowsInserted(0, TaskManagerPage.this.taskList.size() - 1);
            } else {
                this.fireTableRowsDeleted(0, 0);
            }
        }

        public int getRowCount() {
            return TaskManagerPage.this.taskList.size();
        }

        public Object getValueAt(int row, int column) {
            String value;
            if (row >= TaskManagerPage.this.taskList.size()) {
                value = "";
            } else {
                TaskDescriptor task = (TaskDescriptor)TaskManagerPage.this.taskList.get(row);
                value = task.getFieldValue(column);
                if (value.equalsIgnoreCase("N/A")) {
                    value = "";
                }
            }
            return " " + value;
        }
    }

    protected class TaskDatabaseUpdateListener
    implements Runnable {
        boolean active = true;

        public void terminate() {
            this.active = false;
        }

        public void run() {
            if (!this.active) {
                return;
            }
            ArrayList newTaskList = TaskManagerPage.this.getTaskList();
            if (TaskManagerPage.this.taskTable.getSelectedRow() == -1) {
                TaskManagerPage.this.taskList = newTaskList;
                TaskManagerPage.this.taskTableModel.updateDisplay();
            } else {
                int newRow;
                int selectedIndex;
                int oldListSize = TaskManagerPage.this.taskList.size();
                int oldTableSize = TaskManagerPage.this.taskTableModel.getRowCount();
                int[] selectedRows = TaskManagerPage.this.taskTable.getSelectedRows();
                for (selectedIndex = 0; selectedIndex < selectedRows.length; ++selectedIndex) {
                    TaskDescriptor taskDescriptor = (TaskDescriptor)TaskManagerPage.this.taskList.get(selectedRows[selectedIndex]);
                    boolean found = false;
                    for (newRow = 0; newRow < newTaskList.size(); ++newRow) {
                        TaskDescriptor newTaskDescriptor = (TaskDescriptor)newTaskList.get(newRow);
                        if (newTaskDescriptor.task != taskDescriptor.task) continue;
                        found = true;
                        break;
                    }
                    selectedRows[selectedIndex] = found ? newRow : -1;
                }
                TaskManagerPage.this.taskList = newTaskList;
                TaskManagerPage.this.taskTable.clearSelection();
                TaskManagerPage.this.taskTableModel.updateDisplay();
                for (selectedIndex = 0; selectedIndex < selectedRows.length; ++selectedIndex) {
                    newRow = selectedRows[selectedIndex];
                    if (newRow == -1) continue;
                    TaskManagerPage.this.taskTable.addRowSelectionInterval(newRow, newRow);
                }
            }
            TaskManagerPage.this.taskCountLabel.setText(" Task Count: " + TaskManagerPage.this.taskList.size());
        }
    }

    protected class CommLinkUpdateListener
    implements Runnable {
        protected CommLinkUpdateListener() {
        }

        public void run() {
            TaskManagerPage.this.updateTaskMenuItemsState();
        }
    }

    protected class TableSelectionListener
    implements ListSelectionListener {
        protected TableSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            TaskManagerPage.this.updateTaskMenuItemsState();
        }
    }

    class MouseTableListener
    extends MouseAdapter {
        MouseTableListener() {
        }

        public void mouseReleased(MouseEvent evt) {
            int mouseSelectedRow;
            if (evt.getModifiers() == 4 && (mouseSelectedRow = TaskManagerPage.this.taskTable.rowAtPoint(new Point(evt.getX(), evt.getY()))) < TaskManagerPage.this.taskTable.getRowCount()) {
                TaskManagerPage.this.taskTable.addRowSelectionInterval(mouseSelectedRow, mouseSelectedRow);
                Utility.displayPopupMenu(TaskManagerPage.this, TaskManagerPage.this.taskPopupMenu, evt);
            }
        }

        public void mousePressed(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent e) {
        }
    }

    class TaskTableColumnModelListener
    implements TableColumnModelListener {
        TaskTableColumnModelListener() {
        }

        public void columnAdded(TableColumnModelEvent e) {
            TaskManagerPage.this.saveProperties();
        }

        public void columnMoved(TableColumnModelEvent e) {
            TaskManagerPage.this.saveProperties();
        }

        public void columnRemoved(TableColumnModelEvent e) {
        }

        public void columnMarginChanged(ChangeEvent e) {
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }

    class TableKeyListener
    implements KeyListener {
        TableKeyListener() {
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyPressed(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
            String keyText = KeyEvent.getKeyText(e.getKeyCode());
            if (!keyText.equalsIgnoreCase("Delete")) {
                if (keyText.equalsIgnoreCase("Enter")) {
                    e.consume();
                } else if (keyText.equalsIgnoreCase("Up") || keyText.equalsIgnoreCase("Down")) {
                    // empty if block
                }
            }
        }
    }
}

