/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;

public class OEMData {
    private static char[] oemDataBuffer = new char[10000];

    public OEMData(String dataFilePath) throws IOException {
        try {
            FileReader fileReader = new FileReader(dataFilePath);
            fileReader.read(oemDataBuffer);
            fileReader.close();
        }
        catch (Exception e) {
            String errorString = "OEMData: OEMData(): " + dataFilePath + " not found";
            ErrorLog.put(e, errorString);
            Utility.println(errorString);
            throw new FileNotFoundException();
        }
    }

    private String getData(String tag) {
        String OEMString = new String(oemDataBuffer);
        String startTag = "<OEM:" + tag + ">";
        String endTag = "</OEM:" + tag + ">";
        int start = OEMString.indexOf(startTag, 0);
        if (start == -1) {
            return null;
        }
        int end = OEMString.indexOf(endTag, start);
        if (end == -1) {
            return null;
        }
        if (start + startTag.length() == end) {
            return null;
        }
        String dataString = OEMString.substring(start + startTag.length(), end);
        return dataString;
    }

    public String getCompanyName() {
        return this.getData("CompanyName");
    }

    public String getApplicationName() {
        return this.getData("ApplicationName");
    }

    public String getProjectName() {
        return this.getData("ProjectName");
    }

    public String getNoControllerMessage() {
        return this.getData("NoControllerMessage");
    }

    public String getLegacySupportMessage() {
        return this.getData("LegacySupportMessage");
    }
}

