/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.Date;
import java.util.GregorianCalendar;

public class ErrorLog
implements GlobalConstants {
    public static synchronized void put(Exception exception, String callerMessage) {
        String system;
        try {
            system = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            system = "Unknown";
        }
        try {
            GregorianCalendar c = new GregorianCalendar();
            Date timeStamp = c.getTime();
            String details = "Application Exception\nApp:  smu.jar version X.0.0\nSys:  " + system + "\n" + "OS:   " + System.getProperty("os.name") + " version " + System.getProperty("os.version") + "\n" + "Java: JRE version " + System.getProperty("java.version") + " from " + System.getProperty("java.vendor") + "\n" + "Time: " + timeStamp.toString() + "\n\n" + callerMessage + "\n";
            FileOutputStream totalErrorStream = new FileOutputStream(GlobalConstants.userDirectory + GlobalConstants.separatorChar + "Errors.txt", true);
            FileOutputStream lastErrorStream = new FileOutputStream(GlobalConstants.userDirectory + GlobalConstants.separatorChar + "LastError.txt");
            ErrorLog.recordError(totalErrorStream, exception, details, true);
            ErrorLog.recordError(lastErrorStream, exception, details, false);
        }
        catch (Exception e) {
            Utility.println("double exception");
        }
    }

    private static void recordError(FileOutputStream outputStream, Exception exception, String details, boolean border) {
        String borderString = "\n--------------------------------------------------------------------------------\n\n";
        try {
            outputStream.write(details.getBytes());
            if (exception.getMessage() != null) {
                outputStream.write(exception.getMessage().getBytes());
            }
            exception.printStackTrace(new PrintStream(outputStream));
            if (border) {
                outputStream.write(borderString.getBytes());
            }
            outputStream.close();
        }
        catch (Exception e) {
            Utility.println("double exception");
        }
    }
}

