/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class MemberTable
extends JPanel
implements SortInterface,
GlobalConstants {
    KTable memberTable;
    MemberTableModel memberTableModel;
    DeviceDatabase deviceDatabase;
    DatabaseManager databaseManager;
    AbstractMessageHandler messageHandler;
    Object[] defaultColumns;
    ArrayList sortedList;
    SortDescriptor[] sortDescriptors;
    JLabel deviceCountLabel;
    ArrayList memberList;
    JScrollPane scrollPane;
    Preferences preferences;
    String memberFields;
    String[] statuses;

    public MemberTable(DatabaseManager databaseManager, Preferences preferences, String memberFields, String[] statuses, int rowCount) {
        this.preferences = preferences;
        this.databaseManager = databaseManager;
        this.memberFields = memberFields;
        this.statuses = statuses;
        this.deviceDatabase = databaseManager.deviceDatabase;
        System.out.println("member fields = \"" + memberFields + "\"");
        this.loadPreferences();
        this.buildTable(rowCount);
        this.savePreferences();
    }

    public void setSelectionMode(int selectionMode) {
        this.memberTable.setSelectionMode(selectionMode);
    }

    public ArrayList getSelectedMembers() {
        ArrayList<MemberDescriptor> selectedList = new ArrayList<MemberDescriptor>();
        int[] selectedRows = this.memberTable.getSelectedRows();
        for (int count = 0; count < selectedRows.length; ++count) {
            MemberDescriptor memberDescriptor = (MemberDescriptor)this.memberList.get(selectedRows[count]);
            selectedList.add(memberDescriptor);
        }
        return selectedList;
    }

    public void dispose() {
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public KTable getTable() {
        return this.memberTable;
    }

    public MemberTableModel getTableModel() {
        return this.memberTableModel;
    }

    private void savePreferences() {
        int index;
        if (this.memberFields != null) {
            return;
        }
        String columns = "";
        TableColumnModel tableColumnModel = this.memberTable.getColumnModel();
        int count = tableColumnModel.getColumnCount();
        for (index = 0; index < tableColumnModel.getColumnCount(); ++index) {
            columns = index != tableColumnModel.getColumnCount() - 1 ? columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim() + "," : columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim();
        }
        columns.trim();
        this.preferences.put("Table Columns", columns);
        for (index = 0; index < 3; ++index) {
            this.preferences.put("Table Sort Field" + index, MemberDescriptor.fieldNames[this.sortDescriptors[index].field]);
            this.preferences.put("Table Sort Direction" + index, this.sortDescriptors[index].direction == 1 ? "Ascending" : "Descending");
        }
    }

    private void loadPreferences() {
        String[] fieldNames = MemberDescriptor.fieldNames;
        ArrayList<String> fieldList = new ArrayList<String>();
        while (true) {
            int endIndex;
            String columns = this.memberFields != null ? this.memberFields : this.preferences.get("Table Columns", "Member,Status,StartingPlbn");
            int startIndex = 0;
            do {
                if ((endIndex = columns.indexOf(",", startIndex)) == -1) {
                    endIndex = columns.length();
                }
                String columnName = columns.substring(startIndex, endIndex);
                for (int index = 0; index < fieldNames.length; ++index) {
                    if (!fieldNames[index].trim().equals(columnName.trim())) continue;
                    fieldList.add(columnName);
                }
            } while ((startIndex = endIndex + 1) < columns.length());
            if (fieldList.size() > 0) break;
            if (this.memberFields != null) continue;
            this.preferences.put("Table Columns", "RAID Group,Member,Device,Status,Capacity");
        }
        this.defaultColumns = new Object[fieldList.size()];
        for (int index = 0; index < fieldList.size(); ++index) {
            this.defaultColumns[index] = fieldList.get(index);
        }
        String[] defaultFields = new String[]{"RAID Group", "Member", "Device"};
        String[] defaultDirection = new String[]{"Ascending", "Ascending", "Ascending"};
        this.sortDescriptors = new SortDescriptor[3];
        block4: for (int sorter = 0; sorter < this.sortDescriptors.length; ++sorter) {
            String fields = defaultFields[sorter];
            String direction = defaultDirection[sorter];
            if (this.memberFields == null) {
                fields = this.preferences.get("Table Sort Field" + sorter, defaultFields[sorter]);
                direction = this.preferences.get("Table Sort Direction" + sorter, defaultDirection[sorter]);
            }
            for (int index = 0; index < fieldNames.length; ++index) {
                if (!fieldNames[index].equals(fields)) continue;
                this.sortDescriptors[sorter] = new SortDescriptor(index, direction.equals("Ascending") ? 1 : 0);
                continue block4;
            }
        }
    }

    protected void closeFrame() {
    }

    private void buildTable(int rowCount) {
        this.memberList = this.getMemberList();
        this.memberTableModel = new MemberTableModel();
        this.memberTable = new KTable(this.memberTableModel, rowCount);
        this.memberTable.getColumnModel().addColumnModelListener(new DeviceTableColumnModelListener());
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = MemberTable.this.memberTable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = MemberTable.this.memberTable.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 2 && column != -1) {
                    int count;
                    SortDescriptor[] sorters = MemberTable.this.sortDescriptors;
                    SortDescriptor sorter = sorters[0];
                    String name = MemberTable.this.memberTableModel.getColumnName(column);
                    for (count = 0; count < DeviceDescriptor.fieldNames.length && !name.trim().equalsIgnoreCase(DeviceDescriptor.fieldNames[count]); ++count) {
                    }
                    if (count < DeviceDescriptor.fieldNames.length) {
                        int description = sorter.field;
                        if (description != count) {
                            for (int offset = 1; offset >= 0; --offset) {
                                sorters[offset + 1].field = sorters[offset].field;
                                sorters[offset + 1].direction = sorters[offset].direction;
                            }
                            sorter.field = count;
                            sorter.direction = 1;
                        } else {
                            sorter.direction = sorter.direction == 1 ? 0 : 1;
                        }
                        MemberTable.this.setSortDescriptors(sorters);
                    }
                }
            }
        };
        JTableHeader th = this.memberTable.getTableHeader();
        th.addMouseListener(listMouseListener);
        this.scrollPane = new JScrollPane(this.memberTable);
        this.scrollPane.getViewport().setBackground(this.memberTable.getBackground());
    }

    public synchronized void setSortDescriptors(SortDescriptor[] newSorterDescriptors) {
        this.sortDescriptors = newSorterDescriptors;
        this.memberList = this.getMemberList();
        this.memberTableModel.updateDisplay();
        this.savePreferences();
    }

    public synchronized ArrayList getMemberList() {
        ArrayList<Object> newMemberList = new ArrayList<Object>();
        ArrayList<MemberDescriptor> sortedList = new ArrayList<MemberDescriptor>();
        ArrayList raidGroupList = this.databaseManager.raidGroupDatabase.getRaidGroupList(this.statuses);
        for (int raidGroup = 0; raidGroup < raidGroupList.size(); ++raidGroup) {
            RaidGroupDescriptor raidGroupDescriptor = (RaidGroupDescriptor)raidGroupList.get(raidGroup);
            for (int member = 0; member < raidGroupDescriptor.memberArray.size(); ++member) {
                MemberDescriptor memberDescriptor = (MemberDescriptor)raidGroupDescriptor.memberArray.get(member);
                newMemberList.add(memberDescriptor.clone());
            }
        }
        for (int sourceIndex = 0; sourceIndex < newMemberList.size(); ++sourceIndex) {
            MemberDescriptor destMember;
            int result;
            int destIndex;
            MemberDescriptor sourceMember = (MemberDescriptor)newMemberList.get(sourceIndex);
            for (destIndex = 0; destIndex < sortedList.size() && (result = sourceMember.compare(destMember = (MemberDescriptor)sortedList.get(destIndex), this.sortDescriptors[0])) < 1 && (result != 0 || (result = sourceMember.compare(destMember, this.sortDescriptors[1])) < 1 && (result != 0 || sourceMember.compare(destMember, this.sortDescriptors[2]) < 1)); ++destIndex) {
            }
            sortedList.add(destIndex, sourceMember);
        }
        return sortedList;
    }

    class MemberTableModel
    extends KTableModel {
        public MemberTableModel() {
            this.setColumns(MemberDescriptor.fieldNames, MemberDescriptor.maxFieldText);
        }

        public Object[] getDefaultColumns() {
            return MemberTable.this.defaultColumns;
        }

        public void updateDisplay() {
            if (MemberTable.this.memberList.size() > 0) {
                this.fireTableRowsInserted(0, MemberTable.this.memberList.size() - 1);
            } else {
                this.fireTableRowsDeleted(0, 0);
            }
        }

        public int getRowCount() {
            return MemberTable.this.memberList.size();
        }

        public Object getValueAt(int row, int column) {
            String value;
            if (row >= MemberTable.this.memberList.size()) {
                value = "";
            } else {
                MemberDescriptor segment = (MemberDescriptor)MemberTable.this.memberList.get(row);
                value = segment.getFieldValue(column);
                if (value.equalsIgnoreCase("N/A")) {
                    value = "";
                }
            }
            return " " + value;
        }
    }

    class DeviceTableColumnModelListener
    implements TableColumnModelListener {
        DeviceTableColumnModelListener() {
        }

        public void columnAdded(TableColumnModelEvent e) {
            MemberTable.this.savePreferences();
        }

        public void columnMoved(TableColumnModelEvent e) {
            MemberTable.this.savePreferences();
        }

        public void columnRemoved(TableColumnModelEvent e) {
        }

        public void columnMarginChanged(ChangeEvent e) {
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }
}

