/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class SpareTable
extends JPanel
implements SortInterface,
GlobalConstants {
    KTable spareTable;
    SpareManagerTableModel spareTableModel;
    SpareDatabaseUpdateListener spareDatabaseUpdateListener;
    DeviceDatabase deviceDatabase;
    ArrayList spareList;
    Object[] defaultColumns;
    ArrayList sortedList;
    SortDescriptor[] sortDescriptors;
    Preferences preferences;
    JScrollPane scrollPane;
    String metadataFormat;
    String spareFields = "Device,Type,RAID Group,Starting LBN,Capacity";
    protected ArrayList notifyList;

    public SpareTable(DatabaseManager databaseManager, Preferences preferences, int rowCount, String metadataFormat) {
        this.deviceDatabase = databaseManager.deviceDatabase;
        this.preferences = preferences;
        this.metadataFormat = metadataFormat;
        if (metadataFormat.equals("Old")) {
            this.spareFields = "Device,Type,Starting LBN,Capacity";
        }
        this.loadPreferences();
        this.buildTable(rowCount);
        this.spareDatabaseUpdateListener = new SpareDatabaseUpdateListener();
        this.deviceDatabase.addUpdateListener(this.spareDatabaseUpdateListener);
        this.spareDatabaseUpdateListener.run();
        this.notifyList = new ArrayList();
        this.savePreferences();
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public void dispose() {
        this.deviceDatabase.removeUpdateListener(this.spareDatabaseUpdateListener);
        this.removeAllUpdateListeners();
    }

    public synchronized void addUpdateListener(Runnable updateListener) {
        this.notifyList.add(updateListener);
    }

    public synchronized void removeUpdateListener(Runnable updateListener) {
        for (int index = 0; index < this.notifyList.size(); ++index) {
            if ((Runnable)this.notifyList.get(index) != updateListener) continue;
            this.notifyList.remove(index);
            break;
        }
    }

    private synchronized void removeAllUpdateListeners() {
        for (int index = 0; index < this.notifyList.size(); ++index) {
            this.notifyList.remove(index);
        }
    }

    private void notifyListeners() {
        for (int index = 0; index < this.notifyList.size(); ++index) {
            SwingUtilities.invokeLater((Runnable)this.notifyList.get(index));
        }
    }

    public ArrayList getSelectedSpares() {
        ArrayList<SpareDescriptor> selectedList = new ArrayList<SpareDescriptor>();
        int[] selectedRows = this.spareTable.getSelectedRows();
        for (int count = 0; count < selectedRows.length; ++count) {
            SpareDescriptor spareDescriptor = (SpareDescriptor)this.spareList.get(selectedRows[count]);
            selectedList.add(spareDescriptor);
        }
        return selectedList;
    }

    private void savePreferences() {
        String columns = "";
        TableColumnModel tableColumnModel = this.spareTable.getColumnModel();
        int count = tableColumnModel.getColumnCount();
        for (int index = 0; index < tableColumnModel.getColumnCount(); ++index) {
            columns = index != tableColumnModel.getColumnCount() - 1 ? columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim() + "," : columns + ((String)tableColumnModel.getColumn(index).getIdentifier()).trim();
        }
        columns.trim();
        this.preferences.put("Table Columns", columns);
    }

    private void loadPreferences() {
        String[] fieldNames = SpareDescriptor.fieldNames;
        ArrayList<String> fieldList = new ArrayList<String>();
        while (true) {
            int endIndex;
            String columns = this.spareFields != null ? this.spareFields : this.preferences.get("Table Columns", "Device,Type,RAID Group,Starting LBN,Capacity");
            int startIndex = 0;
            do {
                if ((endIndex = columns.indexOf(",", startIndex)) == -1) {
                    endIndex = columns.length();
                }
                String columnName = columns.substring(startIndex, endIndex);
                for (int index = 0; index < fieldNames.length; ++index) {
                    if (!fieldNames[index].trim().equals(columnName.trim())) continue;
                    fieldList.add(columnName);
                }
            } while ((startIndex = endIndex + 1) < columns.length());
            if (fieldList.size() > 0) break;
            if (this.spareFields != null) continue;
            this.preferences.put("Table Columns", "RAID Group,Member,Device,Status,Capacity");
        }
        this.defaultColumns = new Object[fieldList.size()];
        for (int index = 0; index < fieldList.size(); ++index) {
            this.defaultColumns[index] = fieldList.get(index);
        }
        String[] defaultFields = new String[]{"Device", "Type", "RAID Group", "Starting LBN", "Capacity"};
        String[] defaultDirection = new String[]{"Ascending", "Ascending", "Ascending", "Ascending", "Ascending"};
        this.sortDescriptors = new SortDescriptor[3];
        block4: for (int sorter = 0; sorter < this.sortDescriptors.length; ++sorter) {
            String fields = defaultFields[sorter];
            String direction = defaultDirection[sorter];
            if (this.spareFields == null) {
                fields = this.preferences.get("Table Sort Field" + sorter, defaultFields[sorter]);
                direction = this.preferences.get("Table Sort Direction" + sorter, defaultDirection[sorter]);
            }
            for (int index = 0; index < fieldNames.length; ++index) {
                if (!fieldNames[index].equals(fields)) continue;
                this.sortDescriptors[sorter] = new SortDescriptor(index, direction.equals("Ascending") ? 1 : 0);
                continue block4;
            }
        }
    }

    private JScrollPane buildTable(int rowCount) {
        this.spareList = this.getSpareList();
        this.spareTableModel = new SpareManagerTableModel();
        this.spareTable = new KTable(this.spareTableModel, rowCount);
        this.spareTable.getColumnModel().addColumnModelListener(new SpareTableColumnModelListener());
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = SpareTable.this.spareTable.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = SpareTable.this.spareTable.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 2 && column != -1) {
                    int count;
                    SortDescriptor[] sorters = SpareTable.this.sortDescriptors;
                    SortDescriptor sorter = sorters[0];
                    String name = SpareTable.this.spareTableModel.getColumnName(column);
                    for (count = 0; count < SpareDescriptor.fieldNames.length && !name.trim().equalsIgnoreCase(SpareDescriptor.fieldNames[count]); ++count) {
                    }
                    if (count < SpareDescriptor.fieldNames.length) {
                        int description = sorter.field;
                        if (description != count) {
                            for (int offset = 1; offset >= 0; --offset) {
                                sorters[offset + 1].field = sorters[offset].field;
                                sorters[offset + 1].direction = sorters[offset].direction;
                            }
                            sorter.field = count;
                            sorter.direction = 1;
                        } else {
                            sorter.direction = sorter.direction == 1 ? 0 : 1;
                        }
                        SpareTable.this.setSortDescriptors(sorters);
                    }
                }
            }
        };
        this.spareTable.addMouseListener(new MouseTableListener());
        JTableHeader th = this.spareTable.getTableHeader();
        th.addMouseListener(listMouseListener);
        this.scrollPane = new JScrollPane(this.spareTable);
        this.scrollPane.getViewport().setBackground(this.spareTable.getBackground());
        return this.scrollPane;
    }

    public synchronized void setSortDescriptors(SortDescriptor[] newSorterDescriptors) {
        this.sortDescriptors = newSorterDescriptors;
        this.spareDatabaseUpdateListener.run();
        this.savePreferences();
    }

    public synchronized ArrayList getSpareList() {
        ArrayList<SpareDescriptor> newSpareList = new ArrayList<SpareDescriptor>();
        ArrayList<SpareDescriptor> sortedList = new ArrayList<SpareDescriptor>();
        ArrayList deviceList = this.deviceDatabase.getDeviceList();
        for (int deviceIndex = 0; deviceIndex < deviceList.size(); ++deviceIndex) {
            DeviceDescriptor deviceDescriptor = (DeviceDescriptor)deviceList.get(deviceIndex);
            if (deviceDescriptor.status.equals("Unused")) continue;
            for (int segmentIndex = 0; segmentIndex < deviceDescriptor.segmentArray.size(); ++segmentIndex) {
                SpareDescriptor spareDescriptor;
                SegmentDescriptor segmentDescriptor = (SegmentDescriptor)deviceDescriptor.segmentArray.get(segmentIndex);
                if (this.metadataFormat.equals("New")) {
                    if (!segmentDescriptor.status.equals("Dedicated Spare") && !segmentDescriptor.status.equals("Global Spare")) continue;
                    spareDescriptor = new SpareDescriptor();
                    spareDescriptor.device = Integer.toString(deviceDescriptor.device);
                    spareDescriptor.type = segmentDescriptor.status;
                    spareDescriptor.raidGroup = segmentDescriptor.raidGroup;
                    spareDescriptor.startingPlbn = segmentDescriptor.startingPlbn;
                    spareDescriptor.capacity = segmentDescriptor.capacity;
                    newSpareList.add(spareDescriptor);
                    continue;
                }
                if (!segmentDescriptor.status.equals("Legacy Spare")) continue;
                spareDescriptor = new SpareDescriptor();
                spareDescriptor.device = Integer.toString(deviceDescriptor.device);
                spareDescriptor.type = segmentDescriptor.status;
                spareDescriptor.raidGroup = segmentDescriptor.raidGroup;
                spareDescriptor.startingPlbn = segmentDescriptor.startingPlbn;
                spareDescriptor.capacity = segmentDescriptor.capacity;
                newSpareList.add(spareDescriptor);
            }
        }
        for (int sourceIndex = 0; sourceIndex < newSpareList.size(); ++sourceIndex) {
            SpareDescriptor destSpare;
            int result;
            int destIndex;
            SpareDescriptor sourceSpare = (SpareDescriptor)newSpareList.get(sourceIndex);
            for (destIndex = 0; destIndex < sortedList.size() && (result = sourceSpare.compare(destSpare = (SpareDescriptor)sortedList.get(destIndex), this.sortDescriptors[0])) < 1 && (result != 0 || (result = sourceSpare.compare(destSpare, this.sortDescriptors[1])) < 1 && (result != 0 || sourceSpare.compare(destSpare, this.sortDescriptors[2]) < 1)); ++destIndex) {
            }
            sortedList.add(destIndex, sourceSpare);
        }
        return sortedList;
    }

    class SpareManagerTableModel
    extends KTableModel {
        public SpareManagerTableModel() {
            this.setColumns(SpareDescriptor.fieldNames, SpareDescriptor.maxFieldText);
        }

        public Object[] getDefaultColumns() {
            return SpareTable.this.defaultColumns;
        }

        public void updateDisplay() {
            if (SpareTable.this.spareList.size() > 0) {
                this.fireTableRowsInserted(0, SpareTable.this.spareList.size() - 1);
            } else {
                this.fireTableRowsDeleted(0, 0);
            }
        }

        public int getRowCount() {
            return SpareTable.this.spareList.size();
        }

        public Object getValueAt(int row, int column) {
            String value;
            if (row >= SpareTable.this.spareList.size()) {
                value = "";
            } else {
                SpareDescriptor spare = (SpareDescriptor)SpareTable.this.spareList.get(row);
                value = spare.getFieldValue(column);
                if (value.equalsIgnoreCase("N/A")) {
                    value = "";
                }
            }
            return " " + value;
        }
    }

    class SpareTableColumnModelListener
    implements TableColumnModelListener {
        SpareTableColumnModelListener() {
        }

        public void columnAdded(TableColumnModelEvent e) {
            SpareTable.this.savePreferences();
        }

        public void columnMoved(TableColumnModelEvent e) {
            SpareTable.this.savePreferences();
        }

        public void columnRemoved(TableColumnModelEvent e) {
        }

        public void columnMarginChanged(ChangeEvent e) {
        }

        public void columnSelectionChanged(ListSelectionEvent e) {
        }
    }

    class MouseTableListener
    extends MouseAdapter {
        MouseTableListener() {
        }

        public void mouseReleased(MouseEvent evt) {
            int mouseSelectedRow;
            if (evt.getModifiers() == 4 && (mouseSelectedRow = SpareTable.this.spareTable.rowAtPoint(new Point(evt.getX(), evt.getY()))) < SpareTable.this.spareTable.getRowCount()) {
                SpareTable.this.spareTable.addRowSelectionInterval(mouseSelectedRow, mouseSelectedRow);
                SpareDescriptor spareDescriptor = (SpareDescriptor)SpareTable.this.spareList.get(mouseSelectedRow);
            }
            SpareTable.this.notifyListeners();
        }

        public void mousePressed(MouseEvent evt) {
        }

        public void mouseClicked(MouseEvent e) {
        }
    }

    protected class SpareDatabaseUpdateListener
    implements Runnable {
        boolean active = true;

        public void terminate() {
            this.active = false;
        }

        public void run() {
            if (!this.active) {
                return;
            }
            ArrayList newSpareList = SpareTable.this.getSpareList();
            if (SpareTable.this.spareTable.getSelectedRow() == -1) {
                SpareTable.this.spareList = newSpareList;
                SpareTable.this.spareTableModel.updateDisplay();
            } else {
                int newRow;
                int selectedIndex;
                int oldListSize = SpareTable.this.spareList.size();
                int oldTableSize = SpareTable.this.spareTableModel.getRowCount();
                int[] selectedRows = SpareTable.this.spareTable.getSelectedRows();
                for (selectedIndex = 0; selectedIndex < selectedRows.length; ++selectedIndex) {
                    SpareDescriptor spareDescriptor = (SpareDescriptor)SpareTable.this.spareList.get(selectedRows[selectedIndex]);
                    boolean found = false;
                    for (newRow = 0; newRow < newSpareList.size(); ++newRow) {
                        SpareDescriptor newSpareDescriptor = (SpareDescriptor)newSpareList.get(newRow);
                        if (!newSpareDescriptor.device.equals(spareDescriptor.device) || !newSpareDescriptor.type.equals(spareDescriptor.type) || !newSpareDescriptor.raidGroup.equals(spareDescriptor.raidGroup) || !newSpareDescriptor.startingPlbn.equals(spareDescriptor.startingPlbn) || !newSpareDescriptor.capacity.equals(spareDescriptor.capacity)) continue;
                        found = true;
                        break;
                    }
                    selectedRows[selectedIndex] = found ? newRow : -1;
                }
                SpareTable.this.spareList = newSpareList;
                SpareTable.this.spareTable.clearSelection();
                SpareTable.this.spareTableModel.updateDisplay();
                for (selectedIndex = 0; selectedIndex < selectedRows.length; ++selectedIndex) {
                    newRow = selectedRows[selectedIndex];
                    if (newRow == -1) continue;
                    SpareTable.this.spareTable.addRowSelectionInterval(newRow, newRow);
                }
            }
        }
    }
}

