/*
 * Decompiled with CFR 0.152.
 */
public class SegmentDescriptor
extends AbstractDescriptor {
    public String status;
    public String startingPlbn;
    public String capacity;
    public String capacityInBlocks;
    public String raidGroup;
    public String device;
    public String pathId;
    public String targetId;
    private String[] fieldNameLookUp = new String[]{"PathId", "pathId", "TargetId", "targetId", "Device", "device", "Status", "status", "StartingPlbn", "startingPlbn", "Capacity", "capacity", "RaidGroup", "raidGroup"};
    public static final String[] fieldNames = new String[]{"Path ID", "Target ID", "Device", "Status", "Starting LBN", "Capacity", "Raid Group"};
    public static final String[] maxFieldText = new String[]{"XPath IDX", "XTarget IDX", "XDevice", "X0123456789X", "X0123456789X", "X01234567", "X01234567X"};

    SegmentDescriptor() {
        this.nuke();
    }

    SegmentDescriptor(int device, int pathId, int targetId, String data) {
        this.nuke();
        this.device = Integer.toString(device);
        this.pathId = Integer.toString(pathId);
        this.targetId = Integer.toString(targetId);
        this.parseXml(data);
    }

    public void nuke() {
        this.pathId = "Unknown";
        this.targetId = "Unknown";
        this.device = "Unknown";
        this.status = "Unknown";
        this.startingPlbn = "Unknown";
        this.capacity = "Unknown";
        this.capacityInBlocks = "Unknown";
        this.raidGroup = "N/A";
    }

    public synchronized Object clone() {
        SegmentDescriptor newDescriptor = new SegmentDescriptor();
        newDescriptor.pathId = this.pathId;
        newDescriptor.targetId = this.targetId;
        newDescriptor.device = this.device;
        newDescriptor.status = this.status;
        newDescriptor.startingPlbn = this.startingPlbn;
        newDescriptor.capacity = this.capacity;
        newDescriptor.capacityInBlocks = this.capacityInBlocks;
        newDescriptor.raidGroup = this.raidGroup;
        return newDescriptor;
    }

    public synchronized boolean same(SegmentDescriptor descriptor) {
        if (!descriptor.status.equals(this.status)) {
            return false;
        }
        if (!descriptor.startingPlbn.equals(this.startingPlbn)) {
            return false;
        }
        if (!descriptor.capacity.equals(this.capacity)) {
            return false;
        }
        if (!descriptor.capacityInBlocks.equals(this.capacityInBlocks)) {
            return false;
        }
        if (!descriptor.raidGroup.equals(this.raidGroup)) {
            return false;
        }
        if (!descriptor.device.equals(this.device)) {
            return false;
        }
        if (!descriptor.pathId.equals(this.pathId)) {
            return false;
        }
        return descriptor.targetId.equals(this.targetId);
    }

    public synchronized void parseXml(String data) {
        XmlData xmlData = new XmlData(data);
        while (xmlData.getNextElement()) {
            this.parseElement(this.fieldNameLookUp, xmlData.element, xmlData.elementValue);
        }
        this.capacityInBlocks = this.capacity;
        this.capacity = Utility.blocksToBytes(Long.parseLong(this.capacityInBlocks));
    }

    public String getFieldValue(int fieldIndicator) {
        String value = "";
        if (fieldIndicator < this.fieldNameLookUp.length / 2) {
            value = value + this.getValue(this.fieldNameLookUp[fieldIndicator * 2 + 1]);
        }
        return value;
    }

    public int compare(SegmentDescriptor compareDevice, SortDescriptor sortDescriptor) {
        long result;
        if (this.fieldNameLookUp[sortDescriptor.field * 2 + 1].equals("capacity")) {
            long thisCapacity = this.normalizeCapacity(this.capacity);
            long thatCapacity = this.normalizeCapacity(compareDevice.capacity);
            result = thisCapacity - thatCapacity;
        } else {
            result = this.compareFields(this.fieldNameLookUp[sortDescriptor.field * 2 + 1], compareDevice);
        }
        if (sortDescriptor.direction == 1) {
            if (result >= 1L) {
                return -1;
            }
            if (result == 0L) {
                return 0;
            }
            return 1;
        }
        if (result >= 1L) {
            return 1;
        }
        if (result == 0L) {
            return 0;
        }
        return -1;
    }

    private long normalizeCapacity(String capacityString) {
        int endIndex = capacityString.indexOf(" MB");
        long factor = 2048L;
        if (endIndex == -1) {
            endIndex = capacityString.indexOf(" GB");
            factor = 0x200000L;
            if (endIndex == -1) {
                endIndex = capacityString.indexOf(" TB");
                factor = 0x80000000L;
                if (endIndex == -1) {
                    endIndex = capacityString.length();
                    factor = 1L;
                }
            }
        }
        Float floatCapacity = new Float(new Float(capacityString.substring(0, endIndex)).floatValue() * 100.0f);
        long longCapacity = floatCapacity.longValue() * factor;
        return longCapacity;
    }
}

