/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import javax.swing.SwingUtilities;

public class CommManager
implements GlobalConstants {
    public CommLink commLink;
    private StorageManagementUtility storageManagementUtility;
    private HostConnectionManager hostConnectionManager;
    private MessageQueue mailbox;
    private ArrayList notifyList;
    private String enclosure;
    private DatabaseManager databaseManager;
    private MessageProcessingThread messageProcessingThread;
    private String logFileName;
    private ArrayList listenerList;

    public CommManager(StorageManagementUtility storageManagementUtility, HostConnectionManager hostConnectionManager, boolean verbose) {
        this.storageManagementUtility = storageManagementUtility;
        this.hostConnectionManager = hostConnectionManager;
        this.mailbox = new MessageQueue();
        this.notifyList = new ArrayList();
        this.listenerList = new ArrayList();
        try {
            this.commLink = new CommLink(this, this.mailbox, verbose);
        }
        catch (Exception e) {
            Utility.println("X exception");
        }
        MessageProcessingThread messageProcessingThread = new MessageProcessingThread();
        messageProcessingThread.start();
    }

    public void addDatabaseManager(DatabaseManager databaseManager) {
        this.databaseManager = databaseManager;
    }

    public boolean linkActive() {
        return this.commLink.upDownStatus.equals("Up");
    }

    public CommLink getCommLink() {
        if (this.commLink.upDownStatus.equals("Up")) {
            return this.commLink;
        }
        return null;
    }

    public void resetLink() {
        this.commLink.resetLink();
    }

    public String getLastError() {
        return this.commLink.getLastError();
    }

    public int openLocalConnection(int controller) {
        return this.commLink.openLocalLink(controller);
    }

    public int openRemoteConnection(String ipAddress, int controller, int serverPort) {
        return this.commLink.openEthernetLink(ipAddress, controller, serverPort);
    }

    public void closeConnection() {
        if (this.commLink.enabled) {
            this.commLink.closeLink();
        }
    }

    public void reconnectConnection() {
        this.commLink.reconnect();
    }

    public void goodbyeConnection() {
        this.commLink.goodbyeConnection();
    }

    public void remoteDebug(boolean state) {
        this.commLink.remoteDebug(state);
    }

    public int getControllerCount() {
        return this.commLink.getControllerCount();
    }

    public void scanDriveRequest() {
        this.commLink.scanDrive();
    }

    public void removeDriveRequest(int controller, int pathId, int targetId) {
        this.commLink.removeDrive(controller, pathId, targetId);
    }

    public synchronized void addChangeListener(CommLinkChangeListener listener) {
        this.listenerList.add(listener);
    }

    public synchronized void removeChangeListener(CommLinkChangeListener listener) {
        this.listenerList.remove(listener);
    }

    public synchronized void addUpdateListener(Runnable updateListener) {
        this.notifyList.add(updateListener);
    }

    public synchronized void removeUpdateListener(Runnable updateListener) {
        for (int index = 0; index < this.notifyList.size(); ++index) {
            if ((Runnable)this.notifyList.get(index) != updateListener) continue;
            this.notifyList.remove(index);
            break;
        }
    }

    public void linkStatusChange(CommLinkChangeEvent event, String change) {
        int index;
        if (event != null) {
            for (index = 0; index < this.listenerList.size(); ++index) {
                CommLinkChangeListener listener = (CommLinkChangeListener)this.listenerList.get(index);
                if (change.equals("LinkUp")) {
                    listener.linkUp((CommLinkChangeEvent)event.clone());
                    continue;
                }
                listener.linkDown((CommLinkChangeEvent)event.clone());
            }
        }
        for (index = 0; index < this.notifyList.size(); ++index) {
            SwingUtilities.invokeLater((Runnable)this.notifyList.get(index));
        }
    }

    public void sendMessage(Message message) {
        if (this.commLink != null && this.commLink.isConnected()) {
            if (message.mainPageWait) {
                this.storageManagementUtility.setWait();
            }
            this.commLink.sendMessage(message);
        } else {
            Utility.println("Selected connection inactive " + message.action + ": " + message.request);
            message.status = 1;
            if (message.messageHandler != null) {
                Utility.println("Call handle error method for " + message.action + ": " + message.request + " on controller " + message.controller);
                message.messageHandler.dispatchErrorHandler(message);
            }
        }
    }

    public void sendMessage(int controller, String action, String request, AbstractMessageHandler handler) {
        Message message = new Message();
        message.mailSort = 1;
        message.controller = controller;
        message.action = action;
        message.request = request;
        message.messageHandler = handler;
        this.sendMessage(message);
    }

    public void sendMessage(String action, String request, AbstractMessageHandler handler) {
        Message message = new Message();
        message.mailSort = 1;
        message.controller = this.hostConnectionManager.getNexusController();
        message.action = action;
        message.request = request;
        message.messageHandler = handler;
        this.sendMessage(message);
    }

    public void addMessageHandler(String action, AbstractMessageHandler messageHandler) {
        Message message = new Message();
        message.request = "AddMessageHandler";
        message.messageHandler = messageHandler;
        this.mailbox.putMessage(message);
    }

    private class MessageProcessingThread
    extends Thread {
        static final String commThread = "CommManager Thread - ";

        private MessageProcessingThread() {
        }

        public void run() {
            while (true) {
                Message message = null;
                try {
                    message = (Message)CommManager.this.mailbox.getMessage(true);
                    Utility.println("CommManager Thread - msg received");
                    if (message.status != 0) {
                        Utility.println("CommManager Thread - No Good Status: " + message.status);
                        if (message.mainPageWait) {
                            CommManager.this.storageManagementUtility.clearWait();
                        }
                        if (message.messageHandler != null) {
                            Utility.println("CommManager Thread - Calling error handler method for:\n  Action: " + message.action + "\n  Request: " + message.request + "\n  Controller:" + message.controller);
                            message.messageHandler.dispatchErrorHandler(message);
                            continue;
                        }
                        Utility.println("CommManager Thread - No Message Handler Specified for:\n  Action: " + message.action + "\n  Request: " + message.request + "\n  Response: " + message.response);
                        continue;
                    }
                    if (message != null && message.messageHandler != null) {
                        Utility.println("CommManager Thread - Dispatching msg handler");
                        if (message.mainPageWait) {
                            CommManager.this.storageManagementUtility.clearWait();
                        }
                        message.messageHandler.dispatchMessageHandler(message);
                        continue;
                    }
                    if (message == null) {
                        Utility.println("CommManager Thread - Null message received");
                        continue;
                    }
                    Utility.println("CommManager Thread - No Message Handler Specified for:\n  Action: " + message.action + "\n  Request: " + message.request + "\n  Response: " + message.response);
                    continue;
                }
                catch (Exception exception) {
                    if (message != null) {
                        ErrorLog.put(exception, "CommManager Thread - Exception: Message Received:\n  Action: " + message.action + "\n  Request: " + message.request + "\n  Response: " + message.response);
                        continue;
                    }
                    ErrorLog.put(exception, "CommManager Thread - Exception");
                    continue;
                }
                break;
            }
        }
    }
}

